package com.ruoyi.school.paper.controller;

import java.util.List;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;

import cn.dev33.satoken.annotation.SaIgnore;
import lombok.RequiredArgsConstructor;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.*;
import cn.dev33.satoken.annotation.SaCheckPermission;
import org.springframework.web.bind.annotation.*;
import org.springframework.validation.annotation.Validated;
import com.ruoyi.common.annotation.RepeatSubmit;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.PageQuery;
import com.ruoyi.common.core.domain.R;
import com.ruoyi.common.core.validate.AddGroup;
import com.ruoyi.common.core.validate.EditGroup;
import com.ruoyi.common.core.validate.QueryGroup;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.school.paper.domain.vo.DbQuestionBankTestPaperVo;
import com.ruoyi.school.paper.domain.bo.DbQuestionBankTestPaperBo;
import com.ruoyi.school.paper.service.IDbQuestionBankTestPaperService;
import com.ruoyi.common.core.page.TableDataInfo;

/**
 * 试卷题库主
 *
 * @author zyf
 * @date 2023-07-20
 */
@Validated
@RequiredArgsConstructor
@RestController
@RequestMapping("/school-paper/questionBankTestPaper")
@SaIgnore
public class DbQuestionBankTestPaperController extends BaseController {

    private final IDbQuestionBankTestPaperService iDbQuestionBankTestPaperService;

    /**
     * 查询试卷题库主列表
     */
    @GetMapping("/list")
    public TableDataInfo<DbQuestionBankTestPaperVo> list(DbQuestionBankTestPaperBo bo, PageQuery pageQuery) {
        return iDbQuestionBankTestPaperService.queryPageList(bo, pageQuery);
    }

    /**
     * 导出试卷题库主列表
     */
    @Log(title = "试卷题库主", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(DbQuestionBankTestPaperBo bo, HttpServletResponse response) {
        List<DbQuestionBankTestPaperVo> list = iDbQuestionBankTestPaperService.queryList(bo);
        ExcelUtil.exportExcel(list, "试卷题库主", DbQuestionBankTestPaperVo.class, response);
    }

    /**
     * 获取试卷题库主详细信息
     *
     * @param id 主键
     */
    @GetMapping("/{id}")
    public R<DbQuestionBankTestPaperVo> getInfo(@NotNull(message = "主键不能为空")
                                     @PathVariable Long id) {
        return R.ok(iDbQuestionBankTestPaperService.queryById(id));
    }

    /**
     * 新增试卷题库主
     */
    @Log(title = "试卷题库主", businessType = BusinessType.INSERT)
    @RepeatSubmit()
    @PostMapping()
    public R<Void> add(@Validated(AddGroup.class) @RequestBody DbQuestionBankTestPaperBo bo) {
        return toAjax(iDbQuestionBankTestPaperService.insertByBo(bo));
    }

    /**
     * 修改试卷题库主
     */
    @Log(title = "试卷题库主", businessType = BusinessType.UPDATE)
    @RepeatSubmit()
    @PutMapping()
    public R<Void> edit(@Validated(EditGroup.class) @RequestBody DbQuestionBankTestPaperBo bo) {
        return toAjax(iDbQuestionBankTestPaperService.updateByBo(bo));
    }

    /**
     * 删除试卷题库主
     *
     * @param ids 主键串
     */
    @Log(title = "试卷题库主", businessType = BusinessType.DELETE)
    @DeleteMapping("/{ids}")
    public R<Void> remove(@NotEmpty(message = "主键不能为空")
                          @PathVariable Long[] ids) {
        return toAjax(iDbQuestionBankTestPaperService.deleteWithValidByIds(Arrays.asList(ids), true));
    }
}
