package com.ruoyi.school.paper.controller;

import java.util.List;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;

import cn.dev33.satoken.annotation.SaIgnore;
import lombok.RequiredArgsConstructor;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.*;
import cn.dev33.satoken.annotation.SaCheckPermission;
import org.springframework.web.bind.annotation.*;
import org.springframework.validation.annotation.Validated;
import com.ruoyi.common.annotation.RepeatSubmit;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.PageQuery;
import com.ruoyi.common.core.domain.R;
import com.ruoyi.common.core.validate.AddGroup;
import com.ruoyi.common.core.validate.EditGroup;
import com.ruoyi.common.core.validate.QueryGroup;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.school.paper.domain.vo.DbQuestionBankAnswerTestPaperVo;
import com.ruoyi.school.paper.domain.bo.DbQuestionBankAnswerTestPaperBo;
import com.ruoyi.school.paper.service.IDbQuestionBankAnswerTestPaperService;
import com.ruoyi.common.core.page.TableDataInfo;

/**
 * 试卷题目答案
 *
 * @author zyf
 * @date 2023-07-20
 */
@Validated
@RequiredArgsConstructor
@RestController
@RequestMapping("/school-paper/questionBankAnswerTestPaper")
@SaIgnore
public class DbQuestionBankAnswerTestPaperController extends BaseController {

    private final IDbQuestionBankAnswerTestPaperService iDbQuestionBankAnswerTestPaperService;

    /**
     * 查询试卷题目答案列表
     */
    @GetMapping("/list")
    public TableDataInfo<DbQuestionBankAnswerTestPaperVo> list(DbQuestionBankAnswerTestPaperBo bo, PageQuery pageQuery) {
        return iDbQuestionBankAnswerTestPaperService.queryPageList(bo, pageQuery);
    }

    /**
     * 导出试卷题目答案列表
     */
    @Log(title = "试卷题目答案", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(DbQuestionBankAnswerTestPaperBo bo, HttpServletResponse response) {
        List<DbQuestionBankAnswerTestPaperVo> list = iDbQuestionBankAnswerTestPaperService.queryList(bo);
        ExcelUtil.exportExcel(list, "试卷题目答案", DbQuestionBankAnswerTestPaperVo.class, response);
    }

    /**
     * 获取试卷题目答案详细信息
     *
     * @param id 主键
     */
    @GetMapping("/{id}")
    public R<DbQuestionBankAnswerTestPaperVo> getInfo(@NotNull(message = "主键不能为空")
                                     @PathVariable Long id) {
        return R.ok(iDbQuestionBankAnswerTestPaperService.queryById(id));
    }

    /**
     * 新增试卷题目答案
     */
    @Log(title = "试卷题目答案", businessType = BusinessType.INSERT)
    @RepeatSubmit()
    @PostMapping()
    public R<Void> add(@Validated(AddGroup.class) @RequestBody DbQuestionBankAnswerTestPaperBo bo) {
        return toAjax(iDbQuestionBankAnswerTestPaperService.insertByBo(bo));
    }

    /**
     * 修改试卷题目答案
     */
    @Log(title = "试卷题目答案", businessType = BusinessType.UPDATE)
    @RepeatSubmit()
    @PutMapping()
    public R<Void> edit(@Validated(EditGroup.class) @RequestBody DbQuestionBankAnswerTestPaperBo bo) {
        return toAjax(iDbQuestionBankAnswerTestPaperService.updateByBo(bo));
    }

    /**
     * 删除试卷题目答案
     *
     * @param ids 主键串
     */
    @Log(title = "试卷题目答案", businessType = BusinessType.DELETE)
    @DeleteMapping("/{ids}")
    public R<Void> remove(@NotEmpty(message = "主键不能为空")
                          @PathVariable Long[] ids) {
        return toAjax(iDbQuestionBankAnswerTestPaperService.deleteWithValidByIds(Arrays.asList(ids), true));
    }
}
