package com.ruoyi.school.paper.controller;

import java.util.List;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;

import cn.dev33.satoken.annotation.SaIgnore;
import lombok.RequiredArgsConstructor;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.*;
import cn.dev33.satoken.annotation.SaCheckPermission;
import org.springframework.web.bind.annotation.*;
import org.springframework.validation.annotation.Validated;
import com.ruoyi.common.annotation.RepeatSubmit;
import com.ruoyi.common.annotation.Log;
import com.ruoyi.common.core.controller.BaseController;
import com.ruoyi.common.core.domain.PageQuery;
import com.ruoyi.common.core.domain.R;
import com.ruoyi.common.core.validate.AddGroup;
import com.ruoyi.common.core.validate.EditGroup;
import com.ruoyi.common.core.validate.QueryGroup;
import com.ruoyi.common.enums.BusinessType;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.school.paper.domain.vo.DbQuestionBankAnswerVo;
import com.ruoyi.school.paper.domain.bo.DbQuestionBankAnswerBo;
import com.ruoyi.school.paper.service.IDbQuestionBankAnswerService;
import com.ruoyi.common.core.page.TableDataInfo;

/**
 * 题目答案
 *
 * @author zyf
 * @date 2023-07-20
 */
@Validated
@RequiredArgsConstructor
@RestController
@RequestMapping("/school-paper/questionBankAnswer")
@SaIgnore
public class DbQuestionBankAnswerController extends BaseController {

    private final IDbQuestionBankAnswerService iDbQuestionBankAnswerService;

    /**
     * 查询题目答案列表
     */
    @GetMapping("/list")
    public TableDataInfo<DbQuestionBankAnswerVo> list(DbQuestionBankAnswerBo bo, PageQuery pageQuery) {
        return iDbQuestionBankAnswerService.queryPageList(bo, pageQuery);
    }

    /**
     * 导出题目答案列表
     */
    @Log(title = "题目答案", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(DbQuestionBankAnswerBo bo, HttpServletResponse response) {
        List<DbQuestionBankAnswerVo> list = iDbQuestionBankAnswerService.queryList(bo);
        ExcelUtil.exportExcel(list, "题目答案", DbQuestionBankAnswerVo.class, response);
    }

    /**
     * 获取题目答案详细信息
     *
     * @param id 主键
     */
    @GetMapping("/{id}")
    public R<DbQuestionBankAnswerVo> getInfo(@NotNull(message = "主键不能为空")
                                     @PathVariable Long id) {
        return R.ok(iDbQuestionBankAnswerService.queryById(id));
    }

    /**
     * 新增题目答案
     */
    @Log(title = "题目答案", businessType = BusinessType.INSERT)
    @RepeatSubmit()
    @PostMapping()
    public R<Void> add(@Validated(AddGroup.class) @RequestBody DbQuestionBankAnswerBo bo) {
        return toAjax(iDbQuestionBankAnswerService.insertByBo(bo));
    }

    /**
     * 修改题目答案
     */
    @Log(title = "题目答案", businessType = BusinessType.UPDATE)
    @RepeatSubmit()
    @PutMapping()
    public R<Void> edit(@Validated(EditGroup.class) @RequestBody DbQuestionBankAnswerBo bo) {
        return toAjax(iDbQuestionBankAnswerService.updateByBo(bo));
    }

    /**
     * 删除题目答案
     *
     * @param ids 主键串
     */
    @Log(title = "题目答案", businessType = BusinessType.DELETE)
    @DeleteMapping("/{ids}")
    public R<Void> remove(@NotEmpty(message = "主键不能为空")
                          @PathVariable Long[] ids) {
        return toAjax(iDbQuestionBankAnswerService.deleteWithValidByIds(Arrays.asList(ids), true));
    }
}
