<?php

use Illuminate\Routing\Router;
use Illuminate\Support\Facades\Route;
use Dcat\Admin\Admin;

Admin::routes();

Route::group([
    'prefix'     => config('admin.route.prefix'),
    'namespace'  => config('admin.route.namespace'),
    'middleware' => config('admin.route.middleware'),
], function (Router $router) {

    $router->match(['put', 'post'], 'upload/store', 'UploadFileController@storeUpload');

    $router->match(['put', 'post'], 'upload/store-invoice', 'UploadFileController@storeInvoiceUpload');

    $router->get('/', 'HomeController@index');

    $router->resource('category', 'StoreGoodsCategoryController');  //商品分类管理

    $router->resource('tag', 'StoreGoodsTagController');  //商品标签管理

    $router->resource('goods', 'StoreGoodController');  //商品管理

    $router->resource('order', 'StoreOrderController');  //订单管理

    $router->resource('income', 'StoreIncomeController');  //提现管理
});
