<?php

namespace App\Store\Controllers;

use App\Models\StoreGoodsCategory;
use Dcat\Admin\Admin;
use Dcat\Admin\Form;
use Dcat\Admin\Grid;
use Dcat\Admin\Show;
use Dcat\Admin\Http\Controllers\AdminController;

class StoreGoodsCategoryController extends AdminController
{
    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
        return Grid::make(new StoreGoodsCategory(), function (Grid $grid) {
            $grid->addTableClass(['table-text-center']);
            $grid->model()->where(['store_id'=>Admin::user()->id])->orderBy('created_at','DESC');
            $grid->view('admin.grid.tags');
            $grid->setActionClass(Grid\Displayers\Actions::class);
            $grid->column('id')->sortable();
            $grid->column('store_id');
            $grid->column('title');
            $grid->column('created_at');
            $grid->column('updated_at')->sortable();


            $grid->enableDialogCreate();
            $grid->showQuickEditButton();
            $grid->disableEditButton();
            $grid->disableViewButton();

            $grid->disableBatchDelete();
            $grid->simplePaginate();
            $grid->disableFilterButton();
            $grid->quickSearch('title')->placeholder('搜索分类');
            $grid->filter(function (Grid\Filter $filter) {
                $filter->equal('id');

            });
        });
    }

    /**
     * Make a show builder.
     *
     * @param mixed $id
     *
     * @return Show
     */
    protected function detail($id)
    {
        return Show::make($id, new StoreGoodsCategory(), function (Show $show) {
            $show->field('id');
            $show->field('store_id');
            $show->field('title');
            $show->field('created_at');
            $show->field('updated_at');
        });
    }

    /**
     * Make a form builder.
     *
     * @return Form
     */
    protected function form()
    {
        return Form::make(new StoreGoodsCategory(), function (Form $form) {
            if($form->isCreating()){
                $form->hidden('store_id')->value(Admin::user()->id);
            }

            $form->text('title');
        });
    }
}
