<?php

namespace App\Models;

use Dcat\Admin\Traits\HasDateTimeFormatter;

use Illuminate\Database\Eloquent\Model;

class LawyerCost extends Model
{
    use HasDateTimeFormatter;
    protected $table = 'lawyer_cost';

    //月份
    public const MONTH = [
        1 => '1月',
        2 => '2月',
        3 => '3月',
        4 => '4月',
        5 => '5月',
        6 => '6月',
        7 => '7月',
        8 => '8月',
        9 => '9月',
        10 => '10月',
        11 => '11月',
        12 => '12月',
    ];

    //项目
    public const COSTiTEM = [
        ['field' => 'basic_salary', 'name' => '基本工资'],
        ['field' => 'special_additional', 'name' => '专项附加'],
        ['field' => 'social', 'name' => '社保'],
        ['field' => 'social_person_fee', 'name' => '社保个人部分'],
        ['field' => 'social_company_fee', 'name' => '社保单位部分'],
        ['field' => 'accumulation_fund', 'name' => '公积金'],
        ['field' => 'accumulation_fund_person_fee', 'name' => '公积金个人部分'],
        ['field' => 'accumulation_fund_company_fee', 'name' => '公积金单位部分'],
        ['field' => 'annual_inspection_fee', 'name' => '律所年检费'],
        ['field' => 'annuity', 'name' => '律所年金'],
        ['field' => 'posting_tickets_fee', 'name' => '贴票成本'],
        ['field' => 'assistant_fee', 'name' => '助理律师成本'],
        ['field' => 'office_rental_fee', 'name' => '办公室租赁成本'],
        ['field' => 'noticket_cost', 'name' => '无票成本'],
        ['field' => 'personal_income_tax', 'name' => '个人所得税'],
    ];

    public const CommissioniTEM = [
        ['field' => 'received_money', 'name' => '创收已收款'],
        ['field' => 'commission_rate', 'name' => '提成比例'],
        ['field' => 'royalty_amount', 'name' => '可提成金额'],
        ['field' => 'paid_amount', 'name' => '已支付款项'],
        ['field' => 'basic_salary', 'name' => '1.基本工资'],
        ['field' => 'special_additional', 'name' => '2.专项附加'],
        ['field' => 'social_company_fee', 'name' => '3.社保(单位)'],
        ['field' => 'accumulation_fund_company_fee', 'name' => '4.公积金(单位)'],
        ['field' => 'annual_inspection_fee', 'name' => '5.律师年检费'],
        ['field' => 'annuity', 'name' => '6.律师年金'],
        ['field' => 'office_rental_fee', 'name' => '7.办公室租金'],
        ['field' => 'assistant_fee', 'name' => '8.助理律师成本'],
        ['field' => 'advance_fee', 'name' => '9.预支款'],
        ['field' => 'reserved_closing_fee', 'name' => '10.预留结案费'],
        ['field' => 'posting_tickets_money', 'name' => '贴票金额'],
        ['field' => 'commission_retention', 'name' => '提成留底'],
        ['field' => 'payable_commission_amount', 'name' => '可支付提成结算金额'],
        ['field' => 'personal_income_tax', 'name' => '个人所得税'],
    ];

    //基本工资
    public static function getBasiSalary($lawyer_id)
    {
        return self::where(['lawyer_id' => $lawyer_id])->sum('basic_salary');
    }
    //专项附加 
    public static function  getSpecialAdditional($lawyer_id)
    {
        return self::where(['lawyer_id' => $lawyer_id])->sum('special_additional');
    }

    //社保
    public static function  getSocial($lawyer_id)
    {
        $social_person_fee =  self::where(['lawyer_id' => $lawyer_id])->sum('social_person_fee');
        $social_company_fee =  self::where(['lawyer_id' => $lawyer_id])->sum('social_company_fee');
        return $social_person_fee + $social_company_fee;
    }


    //公积金 
    public static function  getAccumulationFund($lawyer_id)
    {
        $accumulation_fund_person_fee =  self::where(['lawyer_id' => $lawyer_id])->sum('accumulation_fund_person_fee');
        $accumulation_fund_company_fee =  self::where(['lawyer_id' => $lawyer_id])->sum('accumulation_fund_company_fee');
        return $accumulation_fund_person_fee + $accumulation_fund_company_fee;
    }

    //预支款
    public static function  getAdvanceFee($lawyer_id)
    {
        return self::where(['lawyer_id' => $lawyer_id])->sum('advance_fee');
    }



    //已支付款项
    public static function getPaidAmount($lawyer_id, $year = 0)
    {
        $paid_amount = 0;
        $where = ['lawyer_id' => $lawyer_id];
        if ($year) {
            $where['year'] = $year;
        }
        $list = self::where($where)->get();
        if ($list->toArray()) {
            $basic_salary = $special_additional = $social_company_fee = $accumulation_fund_company_fee = 0;
            $annual_inspection_fee = $annuity = $office_rental_fee = $assistant_fee = 0;
            foreach ($list as $item) {
                $basic_salary += $item->basic_salary;
                $special_additional += $item->special_additional;
                $social_company_fee += $item->social_company_fee;
                $accumulation_fund_company_fee += $item->accumulation_fund_company_fee;
                $annual_inspection_fee += $item->annual_inspection_fee;
                $annuity += $item->annuity;
                $office_rental_fee += $item->office_rental_fee;
                $assistant_fee += $item->assistant_fee;
            }
            $paid_amount = $basic_salary + $special_additional + $social_company_fee + $accumulation_fund_company_fee + $annual_inspection_fee + $annuity + $office_rental_fee + $assistant_fee;
        }
        return $paid_amount;
    }

    /**
     * 贴票金额
     * commission_rate 提成比例
     * ticket_ratio 贴票比例
     */
    public static function getPostingTicketsMoney($lawyer_id, $year, $commission_rate, $ticket_ratio)
    {
        $ticket = 0;
        $received_money = CovenantReceivePayment::getReceivedMoney($lawyer_id, $year); //创收已收款
        $paid_amount =  LawyerCost::getPaidAmount($lawyer_id, $year); //已支付款项
        $commission = $received_money * ($commission_rate / 100); //提成
        if ($commission_rate == 80) {
            if ($commission > 300000) {
                $ticket = ($received_money - $paid_amount) * ($ticket_ratio / 100);
            }
        } elseif ($commission_rate == 85) {
            if ($commission > 200000) {
                $ticket = ($received_money - $paid_amount) * ($ticket_ratio / 100);
            }
        } elseif ($commission_rate == 88 || $commission_rate == 90) {
            if ($commission > 200000) {
                $ticket = ($received_money - $paid_amount) * ($ticket_ratio / 100);
            }
        }
        return $ticket;
    }
}
