<?php

namespace App\Models;

use Dcat\Admin\Traits\HasDateTimeFormatter;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Covenant extends Model
{
    use HasDateTimeFormatter;
    use SoftDeletes;
    protected $table = 'covenant';

    //合同类型
    public const CTYPE = [
        1 => '民事诉讼代理',
        2 => '刑事诉讼辩护及代理',
        3 => '行政诉讼代理',
        4 => '非诉讼法律事务',
        5 => '咨询和代写法律文书',
        6 => '仲裁业务',
        7 => '法律援助',
    ];

    //结算方式
    public const PAYMENT_METHOD = [
        1 => '开票付款',
        2 => '付款开票'
    ];

    public function principal()
    {
        return  $this->belongsTo(Principal::class, 'principal_id', 'id');
    }

    public function lawyer()
    {
        return  $this->belongsTo(Lawyer::class, 'lawyer_id', 'id');
    }
}
