<?php

namespace App\Imports;

use App\Command\Log;
use App\Models\Brand;
use App\Models\Category;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Concerns\ToCollection;

use function Matrix\trace;

class ImportExcel implements ToCollection
{
    private $className = null;


    public function __construct($className)
    {
        $this->className = $className;
    }

    public function sheets(): array
    {
        // 只处理第一个sheet
        return [
            0 => $this,
        ];
    }

    /**
     * @param Collection $collection
     */
    public function collection(Collection $rows)
    {
        set_time_limit(0);
        // 去掉表头
        unset($rows[0]);
        unset($rows[1]);

        $i = 0;
        foreach ($rows as $k => &$item) {
            if (!$item[1] || !$item[2] || !$item[3] || !$item[4]) {
                continue;
            }
            $i++;
            $item = array_slice($item->toArray(), 0, 21);
            $result = $this->className::CreateImportData($item);
            if (!$result) {
                continue;
            }
            $insert[] = $result;
            $key[] = $k;
            if (is_int($i / 1000)) {
                DB::table($this->className::getTableName())->insert($insert);
                $insert = [];
                unset($key);
                $key = [];
            }
        }
        if (!empty($insert)) {
            DB::table($this->className::getTableName())->insert($insert);
        }
    }

    public function getExt($filename)
    {
        $arr = explode('.', $filename);
        return array_pop($arr);
    }
}
