<?php

namespace App\Admin\Repositories;

use App\Models\Lawyer;
use App\Models\LawyerCost as ModelLawyerCost;
//use Dcat\Admin\Repositories\EloquentRepository;
use Dcat\Admin\Repositories\Repository;
use Dcat\Admin\Grid;

use Illuminate\Support\Collection;

class LawyerCost extends Repository
{
    /**
     * Model.
     *
     * @var string
     */
    //protected $eloquentClass = Model::class;
    public const COSTiTEM = [
        ['field' => 'basic_salary', 'name' => '基本工资'],
        ['field' => 'special_additional', 'name' => '专项附加'],
        ['field' => 'social', 'name' => '社保'],
        ['field' => 'social_person_fee', 'name' => '社保个人部分'],
        ['field' => 'social_company_fee', 'name' => '社保单位部分'],
        ['field' => 'accumulation_fund', 'name' => '公积金'],
        [
            'field' => 'accumulation_fund_person_fee',
            'name' => '公积金个人部分'
        ],
        ['field' => 'accumulation_fund_company_fee', 'name' => '公积金单位部分'],
        ['field' => 'annual_inspection_fee', 'name' => '律所年检费'],
        ['field' => 'annuity', 'name' => '律所年金'],
        ['field' => 'posting_tickets_fee', 'name' => '贴票成本'],
        ['field' => 'assistant_fee', 'name' => '助理律师成本'],
        ['field' => 'office_rental_fee', 'name' => '办公室租赁成本'],
        ['field' => 'noticket_cost', 'name' => '无票成本'],
        ['field' => 'personal_income_tax', 'name' => '个人所得税'],
        ['field' => 'total', 'name' => '合计'],
    ];

    /**
     * 
     * 
     */
    public function get(Grid\Model $model)
    {
        // 获取筛选条件
        $year = $model->filter()->input('year') ?? date("Y");

        $data = [];
        $nowyear = date('Y');
        $monthNum = $year >= $nowyear ? date('m') : 12;

        $fieldTotal = 0;
        $list = ModelLawyerCost::COSTiTEM; //Lawyer::all();
        foreach ($list as $key => $val) {

            $tmp = [];
            $tmp['title'] = $val['name']; //项目名称
            //总计
            $tmp['total'] = 0;

            for ($i = 1; $i <= $monthNum; $i++) {
                $tmp[$i] = '0.00';
                //基本工资
                if ($val['field'] == 'basic_salary') {
                    $basic_salary = ModelLawyerCost::where(['year' => $year, 'month' => $i])->sum('basic_salary');
                    $tmp[$i] = $basic_salary;
                    $fieldTotal += $basic_salary;
                }

                //专项附加
                if ($val['field'] == 'special_additional') {
                    $special_additional = ModelLawyerCost::where(['year' => $year, 'month' => $i])->sum('special_additional');
                    $tmp[$i] = $special_additional;
                    $fieldTotal += $special_additional;
                }
                //社保
                if ($val['field'] == 'social') {
                    $social_person_fee = ModelLawyerCost::where(['year' => $year, 'month' => $i])->sum('social_person_fee');
                    $social_company_fee = ModelLawyerCost::where(['year' => $year, 'month' => $i])->sum('social_company_fee');
                    $tmp[$i] = sprintf("%.2f", ($social_person_fee + $social_company_fee));
                }
                //社保个人部分
                if ($val['field'] == 'social_person_fee') {
                    $social_person_fee = ModelLawyerCost::where(['year' => $year, 'month' => $i])->sum('social_person_fee');
                    $tmp[$i] = $social_person_fee;
                }
                //社保企业部分
                if ($val['field'] == 'social_company_fee') {
                    $social_company_fee = ModelLawyerCost::where(['year' => $year, 'month' => $i])->sum('social_company_fee');
                    $tmp[$i] = $social_company_fee;
                }
                //公积金
                if ($val['field'] == 'accumulation_fund') {
                    $person_fee = ModelLawyerCost::where(['year' => $year, 'month' => $i])->sum('accumulation_fund_person_fee');
                    $company_fee = ModelLawyerCost::where(['year' => $year, 'month' => $i])->sum('accumulation_fund_company_fee');
                    $tmp[$i] = sprintf("%.2f", ($person_fee + $company_fee));
                }
                //公积金个人部分
                if ($val['field'] == 'accumulation_fund_person_fee') {
                    $person_fee = ModelLawyerCost::where(['year' => $year, 'month' => $i])->sum('accumulation_fund_person_fee');
                    $tmp[$i] = sprintf("%.2f", $person_fee);
                }
                //公积金企业部分 
                if ($val['field'] == 'accumulation_fund_company_fee') {
                    $company_fee = ModelLawyerCost::where(['year' => $year, 'month' => $i])->sum('accumulation_fund_company_fee');
                    $tmp[$i] = sprintf("%.2f", $company_fee);
                }
                //律所年检费 
                if ($val['field'] == 'annual_inspection_fee') {
                    $annual_inspection_fee = ModelLawyerCost::where(['year' => $year, 'month' => $i])->sum('annual_inspection_fee');
                    $tmp[$i] = $annual_inspection_fee;
                }
                //律所年金 
                if ($val['field'] == 'annuity') {
                    $annuity = ModelLawyerCost::where(['year' => $year, 'month' => $i])->sum('annuity');
                    $tmp[$i] = $annuity;
                }



                //助理律师成本 
                if ($val['field'] == 'assistant_fee') {
                    $assistant_fee = ModelLawyerCost::where(['year' => $year, 'month' => $i])->sum('assistant_fee');
                    $tmp[$i] = $assistant_fee;
                }

                //办公室租赁成本  
                if ($val['field'] == 'office_rental_fee') {
                    $office_rental_fee = ModelLawyerCost::where(['year' => $year, 'month' => $i])->sum('office_rental_fee');
                    $tmp[$i] = $office_rental_fee;
                }

                //无票成本 
                if ($val['field'] == 'noticket_cost') {
                    $noticket_cost = ModelLawyerCost::where(['year' => $year, 'month' => $i])->sum('noticket_cost');
                    $tmp[$i] = $noticket_cost;
                }

                //个人所得税  
                if ($val['field'] == 'personal_income_tax') {
                    $personal_income_tax = ModelLawyerCost::where(['year' => $year, 'month' => $i])->sum('personal_income_tax');
                    $tmp[$i] = $personal_income_tax;
                }

                //总计
                $tmp['total'] += $tmp[$i];
            }

            $data[$key] = $tmp;
        }
        //总计
        //初始化
        $heji = ['title' => '合计', 'total' => 0];
        for ($i = 0; $i <= $monthNum; $i++) {
            array_push($heji, 0);
        }
        unset($heji[0]);

        foreach ($data as $key => $item) {
            if (isset($item[1])) {
                $heji[1] += $item[1];
            }
            if (isset($item[2])) {
                $heji[2] += $item[2];
            }
            if (isset($item[3])) {
                $heji[3] += $item[3];
            }
            if (isset($item[4])) {
                $heji[4] += $item[4];
            }
            if (isset($item[5])) {
                $heji[5] += $item[5];
            }
            if (isset($item[6])) {
                $heji[6] += $item[6];
            }
            if (isset($item[7])) {
                $heji[7] += $item[7];
            }
            if (isset($item[8])) {
                $heji[8] += $item[8];
            }
            if (isset($item[9])) {
                $heji[9] += $item[9];
            }
            if (isset($item[10])) {
                $heji[10] += $item[10];
            }
            if (isset($item[11])) {
                $heji[11] += $item[11];
            }
            if (isset($item[12])) {
                $heji[12] += $item[12];
            }
            if (isset($item['total'])) {
                $heji['total'] += $item['total'];
            }
        }
        array_push($data, $heji);
        return $data;
        // $data = [
        //     ['id' => 1, 'year' => '2016', 'jzsqNum' => '100', 'jzhpNum' => '100', 'sbTotal' => '100'],
        //     ['id' => 2, 'year' => '2017', 'jzsqNum' => '100', 'jzhpNum' => '100', 'sbTotal' => '100']
        // ];
        // return $data;
    }
}
