<?php

namespace App\Admin\Repositories;

use App\Models\Lawyer;
use App\Models\LawyerCost as ModelLawyerCost;
//use Dcat\Admin\Repositories\EloquentRepository;
use Dcat\Admin\Repositories\Repository;
use Dcat\Admin\Grid;

use Illuminate\Support\Collection;

class LawyerCommission extends Repository
{
    /**
     * Model.
     *
     * @var string
     */
    //protected $eloquentClass = Model::class;


    /**
     * 
     * 
     */
    public function get(Grid\Model $model)
    {
        // 获取筛选条件
        $year = $model->filter()->input('year') ?? date("Y");

        $data = [];
        $nowyear = date('Y');
        $monthNum = $year >= $nowyear ? date('m') : 12;

        $fieldTotal = 0;
        $list = ModelLawyerCost::CommissioniTEM; //Lawyer::all();
        foreach ($list as $key => $val) {

            $tmp = [];
            $tmp['title'] = $val['name']; //项目名称
            //总计
            $tmp['total'] = 0;

            for ($i = 1; $i <= $monthNum; $i++) {
                $tmp[$i] = '0.00';
                //基本工资
                if ($val['field'] == 'basic_salary') {
                    $basic_salary = ModelLawyerCost::where(['year' => $year, 'month' => $i])->sum('basic_salary');
                    $tmp[$i] = $basic_salary;
                    $fieldTotal += $basic_salary;
                }

                //专项附加
                if ($val['field'] == 'special_additional') {
                    $special_additional = ModelLawyerCost::where(['year' => $year, 'month' => $i])->sum('special_additional');
                    $tmp[$i] = $special_additional;
                    $fieldTotal += $special_additional;
                }
                //社保
                if ($val['field'] == 'social') {
                    $social_person_fee = ModelLawyerCost::where(['year' => $year, 'month' => $i])->sum('social_person_fee');
                    $social_company_fee = ModelLawyerCost::where(['year' => $year, 'month' => $i])->sum('social_company_fee');
                    $tmp[$i] = sprintf("%.2f", ($social_person_fee + $social_company_fee));
                }
                //社保个人部分
                if ($val['field'] == 'social_person_fee') {
                    $social_person_fee = ModelLawyerCost::where(['year' => $year, 'month' => $i])->sum('social_person_fee');
                    $tmp[$i] = $social_person_fee;
                }
                //社保企业部分
                if ($val['field'] == 'social_company_fee') {
                    $social_company_fee = ModelLawyerCost::where(['year' => $year, 'month' => $i])->sum('social_company_fee');
                    $tmp[$i] = $social_company_fee;
                }
                //公积金
                if ($val['field'] == 'accumulation_fund') {
                    $person_fee = ModelLawyerCost::where(['year' => $year, 'month' => $i])->sum('accumulation_fund_person_fee');
                    $company_fee = ModelLawyerCost::where(['year' => $year, 'month' => $i])->sum('accumulation_fund_company_fee');
                    $tmp[$i] = sprintf("%.2f", ($person_fee + $company_fee));
                }
                //公积金个人部分
                if ($val['field'] == 'accumulation_fund_person_fee') {
                    $person_fee = ModelLawyerCost::where(['year' => $year, 'month' => $i])->sum('accumulation_fund_person_fee');
                    $tmp[$i] = sprintf("%.2f", $person_fee);
                }
                //公积金企业部分 
                if ($val['field'] == 'accumulation_fund_company_fee') {
                    $company_fee = ModelLawyerCost::where(['year' => $year, 'month' => $i])->sum('accumulation_fund_company_fee');
                    $tmp[$i] = sprintf("%.2f", $company_fee);
                }
                //律所年检费 
                if ($val['field'] == 'annual_inspection_fee') {
                    $annual_inspection_fee = ModelLawyerCost::where(['year' => $year, 'month' => $i])->sum('annual_inspection_fee');
                    $tmp[$i] = $annual_inspection_fee;
                }
                //律所年金 
                if ($val['field'] == 'annuity') {
                    $annuity = ModelLawyerCost::where(['year' => $year, 'month' => $i])->sum('annuity');
                    $tmp[$i] = $annuity;
                }



                //助理律师成本 
                if ($val['field'] == 'assistant_fee') {
                    $assistant_fee = ModelLawyerCost::where(['year' => $year, 'month' => $i])->sum('assistant_fee');
                    $tmp[$i] = $assistant_fee;
                }

                //办公室租赁成本  
                if ($val['field'] == 'office_rental_fee') {
                    $office_rental_fee = ModelLawyerCost::where(['year' => $year, 'month' => $i])->sum('office_rental_fee');
                    $tmp[$i] = $office_rental_fee;
                }

                //无票成本 
                if ($val['field'] == 'noticket_cost') {
                    $noticket_cost = ModelLawyerCost::where(['year' => $year, 'month' => $i])->sum('noticket_cost');
                    $tmp[$i] = $noticket_cost;
                }

                //个人所得税  
                if ($val['field'] == 'personal_income_tax') {
                    $personal_income_tax = ModelLawyerCost::where(['year' => $year, 'month' => $i])->sum('personal_income_tax');
                    $tmp[$i] = $personal_income_tax;
                }

                //总计
                $tmp['total'] += $tmp[$i];
            }

            $data[$key] = $tmp;
        }
        // echo "<pre>";
        // print_r($data);
        // die;
        return $data;
        // $data = [
        //     ['id' => 1, 'year' => '2016', 'jzsqNum' => '100', 'jzhpNum' => '100', 'sbTotal' => '100'],
        //     ['id' => 2, 'year' => '2017', 'jzsqNum' => '100', 'jzhpNum' => '100', 'sbTotal' => '100']
        // ];
        // return $data;
    }
}
