<?php

namespace App\Admin\Forms;

use App\Command\Log;
use Dcat\Admin\Widgets\Form;
use Dcat\Admin\Contracts\LazyRenderable;
use Dcat\Admin\Traits\LazyWidget;
use Exception;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Request;
use App\Models\Covenant as ModelsCovenant;

class CovenantClosedForm extends Form implements LazyRenderable
{
    use LazyWidget;

    /**
     * Handle the form request.
     *
     * @param array $input
     *
     * @return mixed
     */
    public function handle(array $input)
    {
        $cid = $this->payload['id'];
        DB::beginTransaction();
        try {
            $return_fee = floatval($input['return_fee']);
            $uObj = ModelsCovenant::find($cid);
            if ($uObj && $uObj->is_return == 0 && $return_fee) {
                $uObj->is_return = 1;
                $uObj->return_fee = $return_fee;
                $uObj->save();
            }
            DB::commit();
        } catch (\Exception $exception) {
            DB::rollBack();
            return $this->response()->error($exception->getMessage())->refresh();
        }
        return $this->response()->success('提交成功' . $cid)->refresh();
    }


    /**
     * Build a form here.
     */
    public function form()
    {
        $this->html('<div class="row" style="text-align:center;">
                        是否确认已结案
                    </div>');
    }

    /**
     * The data of the form.
     *
     * @return array
     */
    public function default()
    {
        // 获取外部传递参数
        return [];
    }
}
