<?php

namespace App\Admin\Controllers;

use App\Admin\Repositories\Principal;
use App\Models\Covenant as ModelsCovenant;
use App\Models\CovenantReceivePayment as ModelsCovenantReceivePayment;
use Dcat\Admin\Form;
use Dcat\Admin\Grid;
use Dcat\Admin\Show;
use Dcat\Admin\Http\Controllers\AdminController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Dcat\Admin\Widgets\Modal;
use App\Admin\Forms\CovenantInvoiceForm;

class ViewCovenantInvoicedController extends AdminController
{
    /**
     * 查看收款信息
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
        return Grid::make(new ModelsCovenantReceivePayment(), function (Grid $grid) {
            $cid = $grid->model()->filter()->input('cid') ?? 0;

            $grid->tools(function (Grid\Tools $tools) use ($cid) {
                $tools->append(Modal::make()
                    // 大号弹窗
                    ->lg()
                    // 弹窗标题
                    ->title('新增')
                    // 按钮
                    ->button('<button class="btn btn-primary"><i class="feather icon-plus"></i> 新增</button>')
                    // 弹窗内容
                    ->body(CovenantInvoiceForm::make()->payload(['id' => $cid])));
            });

            $grid->model()->where('rtype', 2)->orderBy("id", "desc");
            //$grid->column('id')->sortable();
            $grid->column('invoiced_at', '开票时间');
            $grid->column('invoiced_money', '开票金额');

            $grid->disableViewButton();
            $grid->disableCreateButton();
            $grid->disableRowSelector();

            //文字信息
            $grid->tools(function (Grid\Tools $tools) use ($grid, $cid) {
                $principal = $number = '';
                if ($cid) {
                    $obj = ModelsCovenant::find($cid);
                    $principal = $obj->principal;
                    $number = $obj->number;
                }
                $card_info = "&nbsp;&nbsp;合同编号：{$number}&nbsp;&nbsp;&nbsp;委托人：{$principal}";

                $tools->append($card_info);
            });
        });
    }



    /**
     * Make a form builder.
     *
     * @return Form
     */
    protected function form()
    {
        $form = Form::make(new ModelsCovenantReceivePayment(), function (Form $form) {
            //$form->display('id');
            $form->date('invoiced_at', '收款时间')->format('YYYY-MM-DD');
            $form->text('invoiced_money', '收款金额');

            $form->disableCreatingCheck();
            $form->disableEditingCheck();
            $form->disableViewCheck();
            $form->disableDeleteButton();
            $form->disableViewButton();
            $form->disableListButton();
        });

        return $form;
    }
}
