<?php

namespace App\Admin\Controllers;

use App\Admin\Repositories\Principal;
use App\Models\Principal as ModelsPrincipal;
use Dcat\Admin\Form;
use Dcat\Admin\Grid;
use Dcat\Admin\Show;
use Dcat\Admin\Http\Controllers\AdminController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class PrincipalController extends AdminController
{
    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
        return Grid::make(new Principal(), function (Grid $grid) {
            $ptype = $grid->model()->filter()->input('wtype') ?? 1;
            $grid->model()->where('wtype', $ptype)->orderBy("id", "desc");
            $grid->column('id')->sortable();
            $grid->column('number');
            if ($ptype == 1) {
                $grid->column('company');
                $grid->column('tax_number');
                $grid->column('address');
                $grid->column('tel');
                $grid->column('bank_name');
                $grid->column('bank_account');
                $grid->column('contacts');
            } else {
                $grid->column('name');
                $grid->column('identity_card');
                $grid->column('address', '联系地址');
            }
            $grid->column('phone');
            // $grid->column('created_at');
            // $grid->column('updated_at')->sortable();
            $grid->disableViewButton();

            $grid->filter(function (Grid\Filter $filter) use ($ptype) {
                // 更改为 panel 布局
                $filter->panel();
                $filter->like('company')->width(3);
                $filter->like('tax_number')->width(3);
                $filter->like('name')->width(3);
                $filter->like('identity_card')->width(3);
                $filter->equal('wtype', '类型')->select([1 => '单位', 2 => '个人'])->width(3)->default(1);
            });
        });
    }

    /**
     * Make a show builder.
     *
     * @param mixed $id
     *
     * @return Show
     */
    protected function detail($id)
    {
        return Show::make($id, new Principal(), function (Show $show) {
            $show->field('id');
            $show->field('number');
            $show->field('company');
            $show->field('username');
            $show->field('identity_card');
            $show->field('tax_number');
            $show->field('address');
            $show->field('tel');
            $show->field('bank_name');
            $show->field('bank_account');
            $show->field('contacts');
            $show->field('phone');
            $show->field('created_at');
            $show->field('updated_at');
        });
    }

    /**
     * Make a form builder.
     *
     * @return Form
     */
    protected function form()
    {
        $form = Form::make(new Principal(), function (Form $form) {
            $form->display('id');

            $form->radio('wtype', '类型')
                ->when(1, function (Form $form) {
                    $form->text('company');
                    $form->text('tax_number');
                    $form->text('address');
                    $form->text('tel');
                    $form->text('bank_name');
                    $form->text('bank_account');
                    $form->text('contacts');
                })
                ->when(2, function (Form $form) {
                    $form->text('name');
                    $form->text('identity_card');
                    $form->text('address', '联系地址');
                })
                ->options([
                    1 => '单位',
                    2 => '个人',
                ])
                ->default(1);

            $form->text('phone');

            $form->disableCreatingCheck();
            $form->disableEditingCheck();
            $form->disableViewCheck();
            $form->disableDeleteButton();
            $form->disableViewButton();

            $number = $form->number;
            $form->hidden('number');
            if (!$number) {
                $form->saving(function (Form $form) {
                    $form->number = self::getRandNumber();
                });
            }

            $form->display('created_at');
            $form->display('updated_at');
        });

        return $form;
    }

    //生成编号
    public static function getRandNumber()
    {
        $rndnumber = '';
        $flag = 0;
        do {
            $rndnumber = mt_rand(10000, 99999);
            $rowObj = ModelsPrincipal::where('number', $rndnumber)->count();
            $flag = $rowObj ? 0 :  1;
        } while ($flag < 1);
        return $rndnumber;
    }

    public function getList(Request $request)
    {
        $wtype = $request->get('q'); //委托人类型
        if ($wtype == 1) {
            $list = ModelsPrincipal::where('wtype', $wtype)->limit(1000)->get(['id', 'company as text']);
        } else {
            $list = ModelsPrincipal::where('wtype', $wtype)->limit(1000)->get(['id', 'name as text']);
        }

        return $list->toArray() ? $list : new \stdClass;;
    }
}
