<?php

namespace App\Admin\Controllers;

use App\Models\LawyerCost as ModelLawyerCost;
use App\Admin\Repositories\Lawyer;
use App\Models\Lawyer as ModelsLawyer;
use Dcat\Admin\Form;
use Dcat\Admin\Grid;
use Dcat\Admin\Show;
use Dcat\Admin\Http\Controllers\AdminController;
use Illuminate\Support\Facades\DB;

class LawyerCostListController extends AdminController
{
    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
        return Grid::make(new ModelLawyerCost(), function (Grid $grid) {
            $number = $grid->model()->filter()->input('no') ?? ''; //律师编号
            $year = $grid->model()->filter()->input('year') ?? '';
            $where = [];
            if ($number) {
                $where['number'] = $number;
            }
            if ($year) {
                $where['year'] = $year;
            }
            $grid->model()->where($where);
            //$grid->column('id')->sortable();
            $grid->column('year', '年份');
            $grid->column('month', '月份');
            $grid->column('basic_salary', '基本工资');
            $grid->column('special_additional', '专项附加');
            $grid->column('social', '社保')->display(function ($val) {
                $total = $this->social_person_fee + $this->social_company_fee;
                return sprintf("%.2f", $total);
            });
            $grid->column('social_person_fee', '社保个人部分');
            $grid->column('social_company_fee', '社保公司部分');
            $grid->column('accumulation_fund', '公积金')->display(function ($val) {
                $total = $this->accumulation_fund_person_fee + $this->accumulation_fund_company_fee;
                return sprintf("%.2f", $total);
            });
            $grid->column('accumulation_fund_person_fee', '公积金个人部分');
            $grid->column('accumulation_fund_company_fee', '公积金公司部分');
            $grid->column('annual_inspection_fee', '律所年检费');
            $grid->column('annuity', '律所年金');
            $grid->column('posting_tickets_fee', '贴票成本')->display(function () {
                return $this->assistant_fee;
            });
            $grid->column('assistant_fee', '助理律师成本');
            $grid->column('office_rental_fee', '办公租赁成本');
            $grid->column('noticket_cost', '无票成本');
            $grid->column('personal_income_tax', '个人所得税');
            $grid->column('advance_fee', '预支款');

            $grid->disableViewButton();
            $grid->disableCreateButton();
            $grid->disableRowSelector();

            $grid->filter(function (Grid\Filter $filter) {
                // 更改为 panel 布局
                $filter->panel();
                $filter->like('year', '年份')->width(3)->default(date("Y"));
            });

            //文字信息
            $grid->tools(function (Grid\Tools $tools) use ($grid, $number) {
                $fullname = '';
                if ($number) {
                    $obj = ModelsLawyer::where('number', $number)->first();
                    $fullname = $obj->name;
                }
                $card_info = "&nbsp;&nbsp;律师编号：{$number}&nbsp;&nbsp;&nbsp;律师姓名：{$fullname}";

                $tools->append($card_info);
            });
        });
    }

    /**
     * Make a show builder.
     *
     * @param mixed $id
     *
     * @return Show
     */
    protected function detail($id)
    {
        return Show::make($id, new ModelLawyerCost(), function (Show $show) {
            $show->field('id');
            $show->field('year');
            $show->field('month');
            $show->field('number');
            $show->field('lname');
            $show->field('basic_salary');
            $show->field('social_person_fee');
            $show->field('social_company_fee');
            $show->field('accumulation_fund_person_fee');
            $show->field('accumulation_fund_company_fee');
            $show->field('annual_inspection_fee');
            $show->field('annuity');
            $show->field('office_rental_fee');
            $show->field('noticket_cost');
            $show->field('posting_tickets_fee');
            $show->field('assistant_fee');
            $show->field('special_additional');
            $show->field('advance_fee');
            $show->field('personal_income_tax');
            $show->field('created_at');
            $show->field('updated_at');
        });
    }

    /**
     * Make a form builder.
     *
     * @return Form
     */
    protected function form()
    {
        $form = Form::make(new ModelLawyerCost(), function (Form $form) {
            $form->display('id');
            $form->text('year');
            $form->select('month')->options(ModelLawyerCost::MONTH);
            $form->display('number');
            $form->text('lname');
            $form->text('basic_salary');
            $form->text('social_person_fee');
            $form->text('social_company_fee');
            //$form->display('social', '社保')->default(100);
            $form->text('accumulation_fund_person_fee');
            $form->text('accumulation_fund_company_fee');
            $form->text('annual_inspection_fee');
            $form->text('annuity');
            $form->text('office_rental_fee');
            //$form->text('noticket_cost');
            //$form->text('posting_tickets_fee');
            $form->text('assistant_fee');
            $form->text('special_additional');
            $form->text('advance_fee');
            $form->text('personal_income_tax');

            $form->disableCreatingCheck();
            $form->disableEditingCheck();
            $form->disableViewCheck();
            $form->disableDeleteButton();
            $form->disableViewButton();

            $form->display('created_at');
            $form->display('updated_at');
        });

        //副表保存规格
        $form->saved(
            function (Form $form, $result) {
                $cost_id = $form->getKey();

                $basic_salary = $_POST['basic_salary'] ?? 0;
                $special_additional = $_POST['special_additional'] ?? 0;
                $social_company_fee = $_POST['social_company_fee'] ?? 0;
                $accumulation_fund_company_fee = $_POST['accumulation_fund_company_fee'] ?? 0;
                $assistant_fee = $_POST['assistant_fee'] ?? 0;
                $office_rental_fee = $_POST['office_rental_fee'] ?? 0;
                //无票成本
                if ($result) {
                    $noticket_cost = $basic_salary + $special_additional + $social_company_fee + $accumulation_fund_company_fee + $assistant_fee + $office_rental_fee;
                    DB::table('lawyer_cost')->where("id", $cost_id)->update(['noticket_cost' => $noticket_cost]);
                }
            }
        );

        return $form;
    }
}
