<?php

namespace App\Admin\Controllers;

//use App\Admin\Repositories\LawyerCost;
use App\Admin\Repositories\Lawyer;
use App\Models\LawyerCost as ModelLawyerCost;
use Dcat\Admin\Form;
use Dcat\Admin\Grid;
use Dcat\Admin\Show;
use Dcat\Admin\Http\Controllers\AdminController;
use Illuminate\Support\Facades\DB;

class LawyerCostController extends AdminController
{
    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
        return Grid::make(new Lawyer(), function (Grid $grid) {
            $number = $grid->model()->filter()->input('number') ?? '';
            $name = $grid->model()->filter()->input('name') ?? '';
            $year = $_GET['year'] ?? date("Y");
            //$grid->column('id')->sortable();
            $grid->column('number', '律师编号');
            $grid->column('name', '律师姓名');
            $grid->column('basic_salary', '基本工资')->display(function ($val) use ($year) {
                return self::getBasiSalary($this->number, $year);
            });
            $grid->column('special_additional', '专项附加')->display(function ($val) use ($year) {
                return self::getSpecialAdditional($this->number, $year);
            });
            $grid->column('social', '社保')->display(function ($val) use ($year) {
                return self::getSocial($this->number, $year);
            });
            $grid->column('accumulation_fund', '公积金')->display(function ($val) use ($year) {
                return self::getAccumulationFund($this->number, $year);
            });
            $grid->column('annual_inspection_fee', '律所年检费')->display(function ($val) use ($year) {
                return self::getAnnualInspectionFee($this->number, $year);
            });
            $grid->column('annuity', '律所年金')->display(function ($val) use ($year) {
                return self::getAnnuity($this->number, $year);
            });
            $grid->column('posting_tickets_fee', '贴票成本')->display(function ($val) use ($year) {
                return self::getAssistantFee($this->number, $year);
            });
            $grid->column('assistant_fee', '助理律师成本')->display(function ($val) use ($year) {
                return self::getAssistantFee($this->number, $year);
            });
            $grid->column('office_rental_fee', '办公租赁成本')->display(function ($val) use ($year) {
                return self::getOfficeRentalFee($this->number, $year);
            });
            $grid->column('noticket_cost', '无票成本')->display(function ($val) use ($year) {
                return self::getNoticketCost($this->number, $year);
            });
            $grid->column('personal_income_tax', '个人所得税')->display(function ($val) use ($year) {
                return self::getPersonalIncomeTax($this->number, $year);
            });

            $grid->disableViewButton();
            $grid->disableEditButton();
            $grid->disableDeleteButton();
            $grid->disableRowSelector();

            $grid->filter(function (Grid\Filter $filter) {
                // 更改为 panel 布局
                $filter->panel();
                $filter->like('number', '律师编号')->width(3);
                $filter->like('name', '律师姓名')->width(3);
                $filter->like('year', '年份')->width(3)->default(date("Y"))->ignore();
                //$filter->date('sign_at')->format('YYYY-MM-DD');
            });

            $grid->actions(function (Grid\Displayers\Actions $actions) {
                //$actions->append(new UserBuyCode($actions->row->id));
                //成本汇总
                $actions->append('<a href="/lycost-collect?no=' . $this->number . '" alt="成本汇总" target="_blank">成本汇总</a>');
                // 成本明细
                $actions->append('<a href="/lycost-list?no=' . $this->number . '" alt="成本明细" target="_blank">成本明细</a>');

                // 或者使用 RowAction 来添加按钮
                //$actions->append(RowAction::make('自定义按钮')->route('custom.route'));
            });
        });
    }
    protected function grid2()
    {
        return Grid::make(new ModelLawyerCost(), function (Grid $grid) {
            $grid->column('id')->sortable();
            $grid->column('year');
            $grid->column('month');
            $grid->column('number');
            $grid->column('lname');
            $grid->column('basic_salary');
            $grid->column('social_person_fee');
            $grid->column('social_company_fee');
            $grid->column('accumulation_fund_person_fee');
            $grid->column('accumulation_fund_company_fee');
            $grid->column('annual_inspection_fee');
            $grid->column('annuity');
            $grid->column('office_rental_fee');
            $grid->column('noticket_cost');
            $grid->column('posting_tickets_fee');
            $grid->column('assistant_fee');
            $grid->column('special_additional');
            $grid->column('advance_fee');
            $grid->column('personal_income_tax');
            $grid->column('created_at');
            $grid->column('updated_at')->sortable();

            $grid->filter(function (Grid\Filter $filter) {
                $filter->equal('id');
            });
        });
    }

    //基本工资
    public static function getBasiSalary($number, $year)
    {
        return ModelLawyerCost::where(['number' => $number, 'year' => $year])->sum('basic_salary');
    }
    //专项附加 
    public static function  getSpecialAdditional($number, $year)
    {
        return ModelLawyerCost::where(['number' => $number, 'year' => $year])->sum('special_additional');
    }

    //社保
    public static function  getSocial($number, $year)
    {
        $social_person_fee =  ModelLawyerCost::where(['number' => $number, 'year' => $year])->sum('social_person_fee');
        $social_company_fee =  ModelLawyerCost::where(['number' => $number, 'year' => $year])->sum('social_company_fee');
        return round($social_person_fee + $social_company_fee, 2);
    }


    //公积金 
    public static function  getAccumulationFund($number, $year)
    {
        $accumulation_fund_person_fee =  ModelLawyerCost::where(['number' => $number, 'year' => $year])->sum('accumulation_fund_person_fee');
        $accumulation_fund_company_fee =  ModelLawyerCost::where(['number' => $number, 'year' => $year])->sum('accumulation_fund_company_fee');
        return round($accumulation_fund_person_fee + $accumulation_fund_company_fee, 2);
    }

    //律所年检费 
    public static function  getAnnualInspectionFee($number, $year)
    {
        $annual_inspection_fee =  ModelLawyerCost::where(['number' => $number, 'year' => $year])->sum('annual_inspection_fee');
        return $annual_inspection_fee;
    }

    //律所年金 
    public static function  getAnnuity($number, $year)
    {
        $annuity =  ModelLawyerCost::where(['number' => $number, 'year' => $year])->sum('annuity');
        return $annuity;
    }

    //助理律师成本  
    public static function  getAssistantFee($number, $year)
    {
        $annuity =  ModelLawyerCost::where(['number' => $number, 'year' => $year])->sum('assistant_fee');
        return $annuity;
    }

    //办公室租赁成本  
    public static function  getOfficeRentalFee($number, $year)
    {
        $office_rental_fee =  ModelLawyerCost::where(['number' => $number, 'year' => $year])->sum('office_rental_fee');
        return $office_rental_fee;
    }

    //个人所得税  
    public static function  getPersonalIncomeTax($number, $year)
    {
        $personal_income_tax =  ModelLawyerCost::where(['number' => $number, 'year' => $year])->sum('personal_income_tax');
        return $personal_income_tax;
    }

    //无票成本  
    public static function  getNoticketCost($number, $year)
    {
        $noticket_cost =  ModelLawyerCost::where(['number' => $number, 'year' => $year])->sum('noticket_cost');
        return $noticket_cost;
    }

    /**
     * Make a show builder.
     *
     * @param mixed $id
     *
     * @return Show
     */
    protected function detail($id)
    {
        return Show::make($id, new ModelLawyerCost(), function (Show $show) {
            $show->field('id');
            $show->field('year');
            $show->field('month');
            $show->field('number');
            $show->field('lname');
            $show->field('basic_salary');
            $show->field('social_person_fee');
            $show->field('social_company_fee');
            $show->field('accumulation_fund_person_fee');
            $show->field('accumulation_fund_company_fee');
            $show->field('annual_inspection_fee');
            $show->field('annuity');
            $show->field('office_rental_fee');
            $show->field('noticket_cost');
            $show->field('posting_tickets_fee');
            $show->field('assistant_fee');
            $show->field('special_additional');
            $show->field('advance_fee');
            $show->field('personal_income_tax');
            $show->field('created_at');
            $show->field('updated_at');
        });
    }

    /**
     * Make a form builder.
     *
     * @return Form
     */
    protected function form()
    {
        $form = Form::make(new ModelLawyerCost(), function (Form $form) {
            $form->display('id');
            $form->text('year');
            $form->select('month')->options(ModelLawyerCost::MONTH);
            $form->text('number');
            $form->text('lname');
            $form->text('basic_salary');
            $form->text('social_person_fee');
            $form->text('social_company_fee');
            //$form->display('social', '社保')->default(100);
            $form->text('accumulation_fund_person_fee');
            $form->text('accumulation_fund_company_fee');
            $form->text('annual_inspection_fee');
            $form->text('annuity');
            $form->text('office_rental_fee');
            //$form->text('noticket_cost');
            //$form->text('posting_tickets_fee');
            $form->text('assistant_fee');
            $form->text('special_additional');
            $form->text('advance_fee');
            $form->text('personal_income_tax');

            $form->disableCreatingCheck();
            $form->disableEditingCheck();
            $form->disableViewCheck();
            $form->disableDeleteButton();
            $form->disableViewButton();

            $form->display('created_at');
            $form->display('updated_at');
        });

        //副表保存规格
        $form->saved(
            function (Form $form, $result) {
                $cost_id = $form->getKey();

                $basic_salary = $_POST['basic_salary'] ?? 0;
                $special_additional = $_POST['special_additional'] ?? 0;
                $social_company_fee = $_POST['social_company_fee'] ?? 0;
                $accumulation_fund_company_fee = $_POST['accumulation_fund_company_fee'] ?? 0;
                $assistant_fee = $_POST['assistant_fee'] ?? 0;
                $office_rental_fee = $_POST['office_rental_fee'] ?? 0;
                //无票成本
                if ($result) {
                    $noticket_cost = $basic_salary + $special_additional + $social_company_fee + $accumulation_fund_company_fee + $assistant_fee + $office_rental_fee;
                    DB::table('lawyer_cost')->where("id", $cost_id)->update(['noticket_cost' => $noticket_cost]);
                }
            }
        );

        return $form;
    }
}
