<?php

namespace App\Admin\Controllers;

use App\Models\LawyerCost as ModelLawyerCost;
use App\Admin\Repositories\LawyerCost;
use App\Models\Lawyer as ModelsLawyer;
use Dcat\Admin\Form;
use Dcat\Admin\Grid;
use Dcat\Admin\Show;
use Dcat\Admin\Http\Controllers\AdminController;

class LawyerCostCollectController extends AdminController
{
    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
        $list = ModelLawyerCost::COSTiTEM;
        return Grid::make(new LawyerCost(), function (Grid $grid) use ($list) {
            $number = $grid->model()->filter()->input('no') ?? ''; //律师编号
            $nowyear = date("Y");
            $year = $grid->model()->filter()->input('year') ?? '';
            $monthNum = ($year && $year < $nowyear)  ? 12 : date('m');


            $grid->column('title', '项目名称')->width('10%');
            for ($i = 1; $i <= $monthNum; $i++) {
                $grid->column($i, $i . '月');
            }
            $grid->column('total', '合计');
            // $grid->disableViewButton();
            // $grid->disableCreateButton();

            $grid->filter(function (Grid\Filter $filter) {
                // 更改为 panel 布局
                $filter->panel();
                $filter->like('year', '年份')->width(3)->default(date("Y"));
            });

            $grid->disableRowSelector();
            $grid->disableActions();
            $grid->disableCreateButton();
            $grid->disablePagination();

            //文字信息
            $grid->tools(function (Grid\Tools $tools) use ($grid, $number) {
                $fullname = '';
                if ($number) {
                    $obj = ModelsLawyer::where('number', $number)->first();
                    $fullname = $obj->name;
                }
                $card_info = "&nbsp;&nbsp;律师编号：{$number}&nbsp;&nbsp;&nbsp;律师姓名：{$fullname}";

                $tools->append($card_info);
            });
        });
    }

    /**
     * Make a show builder.
     *
     * @param mixed $id
     *
     * @return Show
     */
    protected function detail($id)
    {
        return Show::make($id, new ModelLawyerCost(), function (Show $show) {
            $show->field('id');
            $show->field('year');
            $show->field('month');
            $show->field('number');
            $show->field('lname');
            $show->field('basic_salary');
            $show->field('social_person_fee');
            $show->field('social_company_fee');
            $show->field('accumulation_fund_person_fee');
            $show->field('accumulation_fund_company_fee');
            $show->field('annual_inspection_fee');
            $show->field('annuity');
            $show->field('office_rental_fee');
            $show->field('noticket_cost');
            $show->field('posting_tickets_fee');
            $show->field('assistant_fee');
            $show->field('special_additional');
            $show->field('advance_fee');
            $show->field('personal_income_tax');
            $show->field('created_at');
            $show->field('updated_at');
        });
    }

    /**
     * Make a form builder.
     *
     * @return Form
     */
    protected function form()
    {
        return Form::make(new ModelLawyerCost(), function (Form $form) {
            $form->display('id');
            $form->text('year');
            $form->select('month')->options(ModelLawyerCost::MONTH);
            $form->display('number');
            $form->text('lname');
            $form->text('basic_salary');
            $form->text('social_person_fee');
            $form->text('social_company_fee');
            //$form->display('social', '社保')->default(100);
            $form->text('accumulation_fund_person_fee');
            $form->text('accumulation_fund_company_fee');
            $form->text('annual_inspection_fee');
            $form->text('annuity');
            $form->text('office_rental_fee');
            //$form->text('noticket_cost');
            //$form->text('posting_tickets_fee');
            $form->text('assistant_fee');
            $form->text('special_additional');
            $form->text('advance_fee');
            $form->text('personal_income_tax');

            $form->disableCreatingCheck();
            $form->disableEditingCheck();
            $form->disableViewCheck();
            $form->disableDeleteButton();
            $form->disableViewButton();

            $form->display('created_at');
            $form->display('updated_at');
        });
    }
}
