<?php

namespace App\Admin\Controllers;

use App\Admin\Repositories\Lawyer;
use App\Models\Lawyer as ModelLawyer;
use Dcat\Admin\Form;
use Dcat\Admin\Grid;
use Dcat\Admin\Show;
use Dcat\Admin\Http\Controllers\AdminController;
use Illuminate\Support\Facades\DB;

class LawyerController extends AdminController
{
    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
        return Grid::make(new Lawyer(), function (Grid $grid) {
            $grid->column('id')->sortable();
            $grid->column('number');
            $grid->column('name');
            $grid->column('sex')->display(function ($val) {
                return $val == 1 ? '男' : '女';
            });
            $grid->column('identity_card');
            $grid->column('phone');
            $grid->column('bank_account');
            $grid->column('sign_at');
            $grid->column('commission_rate');
            $grid->column('settlement_period')->display(function ($val) {
                return $val == 1 ? '月' : '年';
            });
            $grid->column('ticket_ratio', '贴票比例(%)');
            $grid->column('settlement_method', '结算方式')->display(function ($val) {
                return $val == 1 ? '贴票' : '个税';
            });
            // $grid->column('created_at');
            // $grid->column('updated_at')->sortable();
            $grid->disableViewButton();

            $grid->filter(function (Grid\Filter $filter) {
                // 更改为 panel 布局
                $filter->panel();
                $filter->like('name')->width(3);
                $filter->like('identity_card')->width(3);
                $filter->like('phone')->width(3);
                $filter->equal('settlement_period')->select(Lawyer::SETTLEMENT_PERIOD)->width(3);
                $filter->equal('settlement_method')->select(Lawyer::SETTLEMENT_METHOD)->width(3);
            });
        });
    }

    /**
     * Make a show builder.
     *
     * @param mixed $id
     *
     * @return Show
     */
    protected function detail($id)
    {
        return Show::make($id, new Lawyer(), function (Show $show) {
            $show->field('id');
            $show->field('number');
            $show->field('name');
            $show->field('sex');
            $show->field('identity_card');
            $show->field('phone');
            $show->field('bank_account');
            $show->field('sign_at');
            $show->field('commission_rate');
            $show->field('settlement_period');
            $show->field('created_at');
            $show->field('updated_at');
        });
    }

    /**
     * Make a form builder.
     *
     * @return Form
     */
    protected function form()
    {
        $form = Form::make(new Lawyer(), function (Form $form) {
            $form->display('id');
            //$form->text('number');
            $form->text('name')->required();
            $form->select('sex')->options([1 => '男', 2 => '女'])->default(1);
            $form->text('identity_card')->required();
            $form->text('phone')->required();
            $form->text('bank_account')->required();
            $form->date('sign_at')->format('YYYY-MM-DD')->required();
            $form->text('commission_rate')->required();
            $form->select('settlement_period')->options([1 => '月', 2 => '年'])->default(1);
            $form->text('ticket_ratio', '贴票比例')->required();
            $form->select('settlement_method', '结算方式')->options([1 => '贴票', 2 => '个税'])->default(1);

            $form->disableCreatingCheck();
            $form->disableEditingCheck();
            $form->disableViewCheck();
            $form->disableDeleteButton();
            $form->disableViewButton();

            $number = $form->number;
            $form->hidden('number');
            if (!$number) {
                $form->saving(function (Form $form) {
                    $form->number = self::getRandNumber();
                });
            }
            // $form->display('created_at');
            // $form->display('updated_at');
        });

        return $form;
    }

    //生成编号
    public static function getRandNumber()
    {
        $rndnumber = '';
        $flag = 0;
        do {
            $rndnumber = mt_rand(10000, 99999);
            $rowObj = ModelLawyer::where('number', $rndnumber)->count();
            $flag = $rowObj ? 0 :  1;
        } while ($flag < 1);
        return $rndnumber;
    }
}
