<?php

namespace App\Admin\Controllers;

use App\Models\LawyerCost as ModelLawyerCost;
use App\Admin\Repositories\LawyerCommission;
use App\Models\Lawyer as ModelsLawyer;
use Dcat\Admin\Form;
use Dcat\Admin\Grid;
use Dcat\Admin\Show;
use Dcat\Admin\Http\Controllers\AdminController;

class LawyerCommissionCollectController extends AdminController
{
    /**
     * 律师提成汇总
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
        return Grid::make(new LawyerCommission(), function (Grid $grid) {
            $number = $grid->model()->filter()->input('no') ?? ''; //律师编号
            $nowyear = date("Y");
            $year = $grid->model()->filter()->input('year') ?? '';
            $monthNum = ($year && $year < $nowyear)  ? 12 : date('m');


            $grid->column('title', '项目名称')->width('10%');
            for ($i = 1; $i <= $monthNum; $i++) {
                $grid->column($i, $i . '月');
            }
            $grid->column('total', '合计');
            // $grid->disableViewButton();
            // $grid->disableCreateButton();

            $grid->filter(function (Grid\Filter $filter) {
                // 更改为 panel 布局
                $filter->panel();
                $filter->like('year', '年份')->width(3)->default(date("Y"));
            });

            $grid->disableRowSelector();
            $grid->disableActions();
            $grid->disableCreateButton();
            $grid->disablePagination();

            //文字信息
            $grid->tools(function (Grid\Tools $tools) use ($grid, $number) {
                $fullname = '';
                if ($number) {
                    $obj = ModelsLawyer::where('number', $number)->first();
                    $fullname = $obj->name;
                }
                $card_info = "&nbsp;&nbsp;律师编号：{$number}&nbsp;&nbsp;&nbsp;律师姓名：{$fullname}";

                $tools->append($card_info);
            });
        });
    }
}
