<?php

namespace App\Admin\Controllers;

use App\Admin\Repositories\LawyerCollect;
use App\Models\Covenant as ModelsCovenant;
use App\Models\CovenantReceivePayment as ModelsCovenantReceivePayment;
use App\Models\Lawyer as ModelLawyer;
use Dcat\Admin\Form;
use Dcat\Admin\Grid;
use Dcat\Admin\Show;
use Dcat\Admin\Http\Controllers\AdminController;
use App\Admin\Actions\CovenantReceive;
use App\Admin\Actions\CovenantInvoice;

class LawyerCollectController extends AdminController
{
    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
        return Grid::make(new LawyerCollect(), function (Grid $grid) {

            $number = $grid->model()->filter()->input('number') ?? ''; //律师编号
            $received_at = $invoiced_at = [];
            $received_at['start'] = $_GET['received_at']['start'] ?? '';
            $received_at['end'] = $_GET['received_at']['end'] ?? '';
            $invoiced_at['start'] = $_GET['invoiced_at']['start'] ?? '';
            $invoiced_at['end'] = $_GET['invoiced_at']['end'] ?? '';

            //创收已收款
            $received_amount = ModelsCovenantReceivePayment::getReceivedMoneyByNumber($number, $received_at, $invoiced_at);
            //已开票
            $invoiced_money = ModelsCovenantReceivePayment::getInvoicedMoneyByNumber($number, $received_at, $invoiced_at);
            //收款未开票
            $received_noinvoiced = ($received_amount - $invoiced_money) > 0 ? $received_amount - $invoiced_money : 0;
            //开票未收款
            $invoiced_noreceived = ($invoiced_money - $received_amount) > 0 ? $invoiced_money - $received_amount : 0;
            //提成金额
            $commissionAmount = ModelsCovenantReceivePayment::getCommissionAmount($number, $received_at);
            //基本工资
            $basicSalary = ModelsCovenantReceivePayment::getTotalBasicSalary($number, $received_at);
            //专项附加
            $special_additional = ModelsCovenantReceivePayment::getTotalSpecialAdditional($number, $received_at);
            //社保 
            $social = ModelsCovenantReceivePayment::getTotalSocial($number, $received_at);
            //公积金
            $accumulation_fund = ModelsCovenantReceivePayment::getTotalAccumulationFund($number, $received_at);
            // 添加一行表头数据
            $grid->header(function () use ($received_amount, $received_noinvoiced, $commissionAmount, $invoiced_noreceived, $basicSalary, $special_additional, $social, $accumulation_fund) {
                return '<div class="table-responsive table-wrapper complex-container table-middle mt-1 table-collapse " >' .
                    '<table class="table custom-data-table data-table" id="grid-table">
            <thead>
                        <tr>
                                    <th width="160" style="text-align:center;" colspan="2">合计</th>
                                    <th width="90" style="">' . $received_amount . '</th>
                                    <th style="">' . $commissionAmount . '</th>
                                    <th style="">' . $received_noinvoiced . '</th>
                                    <th style="">' . $invoiced_noreceived . '</th>
                                    <th style="">成本合计</th>
                                    <th style="">' . $basicSalary . '</th>
                                    <th style="">' . $special_additional . '</th>
                                    <th style="">' . $social . '</th>
                                    <th style="">' . $accumulation_fund . '</th>
                                    <th style="">10000</th>
                                    <th style="">30000</th>
                                    <th style="">48899</th>
                            </tr>
            </thead>

                                    </tbody>
        </table>'
                    . '</div>';
            });
            //$grid->column('id')->sortable();
            $grid->column('lnumber', '律师编号')->width(90);
            $grid->column('lname', '律师名称')->width(90);
            $grid->column('commission_ratio', '提成比例(%)')->width(100);
            $grid->column('receipt_money', '创收已收款')->width(90);
            $grid->column('commission_amount', '提成金额')->width(90);
            $grid->column('receipt_noinvoice', '已收款未开票')->width(90);
            $grid->column('invoice_noreceipt', '已开票未收款')->width(90);
            $grid->column('cost', '成本合计')->width(90);
            $grid->column('basic_salary', '基本工资')->width(90);
            $grid->column('special_additional', '专项附加')->width(90);
            $grid->column('social', '社保')->width(90);
            $grid->column('accumulation_fund', '公积金')->width(90);
            $grid->column('posting_tickets_fee', '贴票金额')->width(90);
            $grid->column('advance_fee', '预支款')->width(90);
            $grid->column('payable_commission', '可结算提成')->width(90);

            // $grid->column('created_at');
            // $grid->column('updated_at')->sortable();

            $grid->disableCreateButton();
            $grid->disableViewButton();
            $grid->disableRowSelector();
            $grid->disableActions();

            $grid->filter(function (Grid\Filter $filter) {
                // 更改为 panel 布局
                $filter->panel();
                $filter->like('number', '律师编号')->width(3);
                $filter->like('name', '律师姓名')->width(3);
                $filter->between('received_at', '收款日期')->month()->width(4);
                $filter->between('invoiced_at', '开票日期')->month()->width(4);
            });
        });
    }
}
