<?php

namespace App\Admin\Controllers;

use App\Models\CovenantReceivePayment as ModelsCovenantReceivePayment;
use App\Models\Covenant as ModelsCovenant;
use Dcat\Admin\Form;
use Dcat\Admin\Grid;
use Dcat\Admin\Show;
use Dcat\Admin\Http\Controllers\AdminController;
use App\Admin\Repositories\CovenantReceivePaymentCollect;

class CovenantReceivePaymentController extends AdminController
{
    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
        return Grid::make(new CovenantReceivePaymentCollect(), function (Grid $grid) {
            //已收款
            $receivedMoney = ModelsCovenantReceivePayment::getReceivedMoney();
            //开票金额
            $invoicedMoney = ModelsCovenantReceivePayment::getInvoicedMoney();
            //已收款未开票
            $receiptNoinvoice = ModelsCovenantReceivePayment::getReceiptNoinvoice();
            //已开票未收款
            $invoiceNoreceipt = ModelsCovenantReceivePayment::getInvoiceNoreceipt();
            // 添加一行表头数据
            $grid->header(function () use ($invoicedMoney, $receivedMoney, $receiptNoinvoice, $invoiceNoreceipt) {
                return '<div class="row" style="text-align:center;">' .
                    '<div class="col-md-7">合计</div>' .
                    '<div class="col-md-1">' . $invoicedMoney . '</div>' .
                    '<div class="col-md-1">' . $receivedMoney . '</div>' .
                    '<div class="col-md-1">' . $receiptNoinvoice . '</div>' .
                    '<div class="col-md-1">' . $invoiceNoreceipt . '</div>' .
                    '</div>';
            });
            //$grid->column('id')->sortable();
            $grid->column('lnum', '律师编号');
            $grid->column('lname', '律师姓名');
            $grid->column('covenant_num', '合同编号');
            $grid->column('covenant_name', '合同名称');
            $grid->column('covenant_type', '合同类型');
            $grid->column('principal', '委托人');
            $grid->column('invoice_amount', '开票金额');
            $grid->column('receipt_money', '已收款');
            $grid->column('receipt_noinvoice', '已收款未开票');
            $grid->column('invoice_noreceipt', '已开票未收款');
            //$grid->column('updated_at')->sortable();

            $grid->disableCreateButton();
            $grid->disableRowSelector();
            $grid->disableActions();

            $grid->filter(function (Grid\Filter $filter) {
                // 更改为 panel 布局
                $filter->panel();
                $filter->like('lnum', '律师编号')->width(3);
                $filter->like('lname', '律师名称')->width(3);
                $filter->like('cnum', '合同编号')->width(3);
                $filter->equal('ctype', '合同类型')->select(ModelsCovenant::CTYPE)->width(3);
                $filter->like('principal', '委托人')->width(3);
                $filter->between('received_at', '收款日期')->date()->width(4);
                $filter->between('invoiced_at', '开票日期')->date()->width(4);
            });
        });
    }
}
