<?php

namespace App\Store\Forms;

use App\Command\Log;

use App\Models\Pay;
use App\Models\PaymentRecord;
use App\Models\StoreGood;
use App\Models\StoreInfo;
use App\Models\StoreOrder;
use App\Models\UserRefund;
use Dcat\Admin\Widgets\Form;
use Dcat\Admin\Contracts\LazyRenderable;
use Dcat\Admin\Traits\LazyWidget;
use Illuminate\Support\Facades\DB;


class RefundToExamine extends Form implements LazyRenderable
{
    use LazyWidget;

    /**
     * Handle the form request.
     *
     * @param array $input
     *
     * @return mixed
     */
    public function handle(array $input)
    {
        $model = StoreOrder::find($this->payload['id']);
        DB::beginTransaction();
        try {
            $userRefund = UserRefund::where([
                'order_id'=>$model->order->id,
                'son_order_id'=>$model->id
            ])->first();
            if($input['refund_status']){
                if($model->order->status == 2){
                    $store = StoreInfo::find($model->store_id);
                    $store->total_revenue -= $model->order->pay_money;
                    $store->balance -= $model->order->pay_money;
                    $store->save();
                }
                $wxOrderSn = PaymentRecord::where(['order_id'=>$model->order_id])->first()->other_order;
                $r_sn = Pay::refund($wxOrderSn,$model->order->pay_money,$model->order->refund_amount);
                $userRefund->refund_no = $r_sn;
                $userRefund->status = 1;
                $userRefund->save();
                $model->status = 4;
                $model->save();
                $model->order->status = 8;
                $model->order->save();
                $goods = StoreGood::find($model->goods_id);
                $goods->sale_num -= $model->num;
                $goods->inventory += $model->num;
                $goods->save();
                Log::add('审批同意退款完成',$model->toArray());
                DB::commit();
            }else{
                $userRefund->status = 2;
                $userRefund->save();
                $model->status = $userRefund->son_order_status;
                $model->save();
            }
            DB::commit();
            Log::add('退款审批',$model->toArray());
        }catch (\Exception $exception){
            DB::rollBack();
            Log::add('退款审批失败',$exception);
            return $this->response()->error('退款审批失败')->refresh();
        }

        return $this->response()->success('退款审批成功')->refresh();
    }

    /**
     * Build a form here.
     */
    public function form()
    {
        $this->radio('refund_status','退款审批')->options([true=>'同意退款',false=>'拒绝退款'])->required();
    }

    /**
     * The data of the form.
     *
     * @return array
     */
    public function default()
    {
        // 获取外部传递参数
        return [];
    }
}
