<?php

namespace App\Store\Controllers;

use App\Models\UserAddress;
use App\Models\UserRefund;
use App\Store\Actions\Grid\RefundToExamine;
use App\Store\Actions\Grid\SendOutGoods;
use App\Models\StoreOrder;
use App\Models\TotalOrder;
use App\Models\User;
use Dcat\Admin\Admin;
use Dcat\Admin\Form;
use Dcat\Admin\Grid;
use Dcat\Admin\Show;
use Dcat\Admin\Http\Controllers\AdminController;
use Dcat\Admin\Widgets\Card;

class StoreOrderController extends AdminController
{
    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
        return Grid::make(StoreOrder::with(['order','store_info','store_goods']), function (Grid $grid) {
            $grid->addTableClass(['table-text-center']);
            $grid->model()->where(['store_id'=>Admin::user()->id])->orderBy('created_at','DESC');
            $grid->column('id')->sortable();
            $grid->column('store_goods.title','商品');
            $grid->column('num');
            $grid->column('order.pay_money','金额');
            $grid->column('store_info.name','商户');
            $grid->column('order.uid','用户')->display(function ($val){
                return User::find($val)->name ?? '';
            });

            $grid->column('address_id','收货信息')->if(function ($column){
                return $column->getValue();
            })->display('点击查看')
            ->modal(function ($modal){
                //设置弹窗标题
                $modal->title('收货信息');
                $address = UserAddress::find($this->address_id);

                $name = $address->name ?? '';
                $phone = $address->phone ?? '';
                $area = $address->area ?? '';
                $address = $address->address ?? '';
                $content = '<p>收货人 ：'. $name .'</p><br/><p>电话 ：'.$phone.'</p><br/><p>所在地区 ：'.$area.'</p><br/><p>详细地址 ：'.$address.'</p>';
                $card = new Card(null, $content);

                return "<div style='padding:10px 10px 0'>$card</div>";
            })->else(function (Grid\Column $column) {
                   return '';
                });
            $grid->column('status','流程状态')
                ->if(function ($column){
                    return $column->getValue() == 0 && $this->order->status == 1;
                })->display('点击发货')
                ->expand(new SendOutGoods())
                ->if(function ($column){
                    return $column->getValue() == 3 && in_array($this->order->status,[1,2]);
                })->display('退款审核')
                ->expand(new RefundToExamine())
                ->else(function ($column){
                    $column->using(StoreOrder::STATUS)->dot([
                        0=>'#b9c3cd',
                        1=>'#59a9f8',
                        2=>'#21b978',
                        3=>'#dda451',
                        4=>'#ea5455',
                    ]);
                });
            $grid->column('order.status','订单状态')
                ->using(TotalOrder::STATUS)
                ->dot([
                    0 => '#b9c3cd',
                    1 => '#59a9f8',
                    2 => '#21b978',
                    7 => '#dda451',
                    8 => '#ea5455',
                ]);

            $grid->column('发货物流')->display(function (){
               if(!$this->logistics || !$this->logistics_code){
                   return '';
               }
               return $this->logistics_code . "[$this->logistics]";
            });
            $grid->column('退货物流')->display(function (){
                if(!$this->refund_logistics || !$this->refund_logistics_code){
                    return '';
                }
                return $this->refund_logistics_code . "[$this->refund_logistics]";
            });
            $grid->column('退款申请信息') ->if(function ($column){
                return $this->status == 3;
            })->display('点击查看')->modal(function ($modal){
                //设置弹窗标题
                $modal->title('退款申请信息');
                $userRefund = UserRefund::where(['order_id'=>$this->order->id,'son_order_id'=>$this->id])->first();
                $phone = $userRefund->phone ??'';
                $content = '<p>原因 ：'. $this->order->refund_reason .'</p><br/><p>电话 ：'.$phone.'</p>';
                if($this->voucher){
                    $voucher = json_decode($this->voucher);
                    $content .= '<br/><p>凭证图片:</p>';
                    foreach ($voucher as $item){
                        $content .= '<br/><img src="'.env("IMAGE_URL").$item.'">';
                    }
                }
                $card = new Card(null, $content);

                return "<div style='padding:10px 10px 0'>$card</div>";
            })->else(function ($column){
                return '';
            });

            $grid->column('created_at');

            $grid->simplePaginate();
            $grid->disableActions();
            $grid->disableCreateButton();
            $grid->disableBatchActions();
            $grid->simplePaginate();
            $grid->disableFilterButton();
            $grid->quickSearch('store_goods.title')->placeholder('搜索商品');
            $grid->filter(function (Grid\Filter $filter) {
                $filter->equal('id');

            });
        });
    }

    /**
     * Make a show builder.
     *
     * @param mixed $id
     *
     * @return Show
     */
    protected function detail($id)
    {
        return Show::make($id, new StoreOrder(), function (Show $show) {
            $show->field('id');
            $show->field('order_id');
            $show->field('goods_id');
            $show->field('num');
            $show->field('address_id');
            $show->field('status');
            $show->field('over_time');
            $show->field('voucher');
            $show->field('created_at');
            $show->field('updated_at');
        });
    }

    /**
     * Make a form builder.
     *
     * @return Form
     */
    protected function form()
    {
        return Form::make(new StoreOrder(), function (Form $form) {
            $form->display('id');
            $form->text('order_id');
            $form->text('goods_id');
            $form->text('num');
            $form->text('address_id');
            $form->text('status');
            $form->text('over_time');
            $form->text('voucher');

            $form->display('created_at');
            $form->display('updated_at');
        });
    }
}
