<?php

namespace App\Store\Controllers;

use App\Models\StoreIncome;
use App\Store\Actions\Grid\IncomeApply;
use Dcat\Admin\Admin;
use Dcat\Admin\Form;
use Dcat\Admin\Grid;
use Dcat\Admin\Show;
use Dcat\Admin\Http\Controllers\AdminController;
use Dcat\Admin\Widgets\Card;

class StoreIncomeController extends AdminController
{
    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
        return Grid::make(new StoreIncome(), function (Grid $grid) {
            $grid->tools(new IncomeApply());
            $grid->addTableClass(['table-text-center']);
            $grid->model()->where(['store_id'=>Admin::user()->id])->orderBy('created_at','DESC');
            $grid->column('id')->sortable();
            $grid->column('amount','金额');
            $grid->column('invoice')->if(function ($column){
                return $column->getValue();
            })->display('点击查看')->modal(function ($modal){
                //设置弹窗标题
                $modal->title('发票信息');
                $content =  '';
                $invoice = json_decode($this->invoice);
                foreach ($invoice as $item){
                    $content .= '<br/><img src="'.env("IMAGE_URL").$item.'">';
                }
                $card = new Card(null, $content);

                return "<div style='padding:10px 10px 0;text-align: center'>$card</div>";
            })->else(function ($column){
                return '未设置';
            });
            $grid->column('feedback')->limit(20);
            $grid->column('status')->using(StoreIncome::STATUS)->dot([
                0 => 'primary',
                1 => 'success',
                2 => 'danger'
            ]);
            $grid->column('created_at');

            $grid->disableDeleteButton();
            $grid->disableViewButton();
            $grid->disableCreateButton();
            $grid->disableBatchActions();
            $grid->showQuickEditButton();
            $grid->simplePaginate();
            $grid->disableFilterButton();
            $grid->selector(function (Grid\Tools\Selector $selector) {
                $selector->selectOne('status', '状态',StoreIncome::STATUS);
            });
            $grid->filter(function (Grid\Filter $filter) {
                $filter->equal('id');

            });
        });
    }

    /**
     * Make a show builder.
     *
     * @param mixed $id
     *
     * @return Show
     */
    protected function detail($id)
    {
        return Show::make($id, new StoreIncome(), function (Show $show) {
            $show->field('id');
            $show->field('amout');
            $show->field('invoice');
            $show->field('feedback');
            $show->field('status');
            $show->field('created_at');
            $show->field('updated_at');
        });
    }

    /**
     * Make a form builder.
     *
     * @return Form
     */
    protected function form()
    {
        return Form::make(new StoreIncome(), function (Form $form) {
            $form->currency('amount','金额')->symbol('￥')->required();
            $form->multipleImage('invoice','发票信息')
                ->accept('jpg,jpeg,png')
                ->maxSize(2048)
                ->limit(9)
                ->url('upload/store-invoice')
                ->help('仅支持jpg、jpeg、png格式图片上传')
                ->autoUpload()
                ->saveAsJson();
        });
    }
}
