<?php

namespace App\Store\Actions\Grid;

use App\Store\Forms\SendOutGoods as FormSendOutGoods;

use Dcat\Admin\Grid\RowAction;
use Dcat\Admin\Traits\HasPermissions;
use Dcat\Admin\Widgets\Modal;
use Illuminate\Contracts\Auth\Authenticatable;
use Illuminate\Database\Eloquent\Model;


class SendOutGoods extends RowAction
{
    /**
     * @return string
     */
    protected $title = '<span>订单发货</span>';

    public function render()
    {
        $form = FormSendOutGoods::make()->payload(['id' => $this->getKey()]);
        return Modal::make()
            ->lg()
            ->title($this->title)
            ->body($form)
            ->scrollable(true)
            ->button($this->title);
    }
    /**
     * @return string|array|void
     */
    public function confirm()
    {
        // return ['Confirm?', 'contents'];
    }

    /**
     * @param Model|Authenticatable|HasPermissions|null $user
     *
     * @return bool
     */
    protected function authorize($user): bool
    {
        return true;
    }

    /**
     * @return array
     */
    protected function parameters()
    {
        return [];
    }
}
