<?php

namespace App\Store\Actions\Grid;

use App\Store\Forms\IncomeApply as FormIncomeApply;

use Dcat\Admin\Grid\RowAction;
use Dcat\Admin\Traits\HasPermissions;
use Dcat\Admin\Widgets\Modal;
use Illuminate\Contracts\Auth\Authenticatable;
use Illuminate\Database\Eloquent\Model;


class IncomeApply extends RowAction
{
    /**
     * @return string
     */
    protected $title = '<button class="btn btn-custom disable-outline "> 申请提现 </button>';

    public function render()
    {
        $form = FormIncomeApply::make();
        return Modal::make()
            ->lg()
            ->title('申请提现')
            ->body($form)
            ->scrollable(true)
            ->button($this->title);
    }
    /**
     * @return string|array|void
     */
    public function confirm()
    {
        // return ['Confirm?', 'contents'];
    }

    /**
     * @param Model|Authenticatable|HasPermissions|null $user
     *
     * @return bool
     */
    protected function authorize($user): bool
    {
        return true;
    }

    /**
     * @return array
     */
    protected function parameters()
    {
        return [];
    }
}
