<?php

namespace App\Models;

use Dcat\Admin\Traits\HasDateTimeFormatter;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class Lawyer extends Model
{
    use HasDateTimeFormatter;
    protected $table = 'lawyer';

    //律师汇总表 总基本工资
    public static function getTotalBasiSalary($params, $received_at, $invoiced_at)
    {
        // 获取筛选条件
        $lnum = $params['lnum'] ?? '';
        $lname = $params['lname'] ?? '';
        $year = $params['year'] ?? date('Y');

        DB::enableQueryLog();
        $list = [];
        $note_monitor = DB::table('covenant_receive_payment AS rp')
            ->select(['rp.*', 'l.name as lname', 'l.number as lnumber', 'l.commission_rate'])
            ->leftJoin('lawyer as l', 'rp.lawyer_id', '=', 'l.id');
        if ($lnum) {
            $note_monitor = $note_monitor->where("l.number", $lnum);
        }
        if ($lname) {
            $note_monitor = $note_monitor->where("l.name", $lname);
        }
        if ($year) {
            $note_monitor = $note_monitor->where("rp.year", $year);
        }
        if ($invoiced_at['start'] && $received_at['start']) {
            $in_start = $invoiced_at['start'] ?? '';
            $in_end = $invoiced_at['end'] ?? '';
            $re_start = $received_at['start'] ?? '';
            $re_end = $received_at['end'] ?? '';

            if ($in_start && $re_start) {
                if ($in_end && $re_end) {
                    $note_monitor = $note_monitor->whereBetween('rp.received_at', [$re_start, $re_end])
                        ->whereBetween('rp.invoiced_at', [$in_start, $in_end]);
                } else {
                    if ($in_end) {
                        $note_monitor = $note_monitor->whereDate('rp.received_at', '>', $re_start)
                            ->whereBetween('rp.invoiced_at', [$in_start, $in_end]);
                    } elseif ($re_end) {
                        $note_monitor = $note_monitor->whereDate('rp.invoiced_at', '>', $in_start)
                            ->whereBetween('rp.received_at', [$re_start, $re_end]);
                    } else {
                        $note_monitor = $note_monitor->whereDate('rp.invoiced_at', '>', $in_start)
                            ->whereDate('rp.received_at', '>', $re_start);
                    }
                }
            }
        } elseif ($invoiced_at['start'] && !$received_at['start']) { //开票日期
            $start = $invoiced_at['start'] ?? '';
            $end = $invoiced_at['end'] ?? '';

            if ($start) {
                if ($end) {
                    $note_monitor = $note_monitor->whereBetween('rp.received_at', [$start, $end]);
                } else {
                    $note_monitor = $note_monitor->whereDate('rp.received_at', '>', $start);
                }
            }
            //
        } elseif ($received_at['start'] && !$invoiced_at['start']) { //收款日期
            $start = $received_at['start'] ?? '';
            $end = $received_at['end'] ?? '';

            if ($start) {
                if ($end) {
                    $note_monitor = $note_monitor->whereBetween('rp.received_at', [$start, $end]);
                } else {
                    $note_monitor = $note_monitor->whereDate('rp.received_at', '>', $start);
                }
            }
        }

        // 获取列表
        $total = 0;
        $list = $note_monitor->limit(1000)->groupBy('rp.lawyer_id')->get()->toArray();
        foreach ($list as $item) {
            $salary = LawyerCost::getBasiSalary($item->lawyer_id, $year);
            $total += $salary;
        }

        //$queries = DB::getQueryLog();
        return $total;
    }

    //律师汇总表 律师基本信息统计
    public static function getTotalInfo($params, $received_at, $invoiced_at)
    {
        // 获取筛选条件
        $lnum = $params['lnum'] ?? '';
        $lname = $params['lname'] ?? '';
        $year = $params['year'] ?? date('Y');

        DB::enableQueryLog();
        $list = [];
        $note_monitor = DB::table('covenant_receive_payment AS rp')
            ->select(DB::raw('rp.lawyer_id,rp.year,l.number as lnumber,l.name as lname,l.commission_rate,sum(invoiced_money) as invoiced_money,sum(received_amount) as received_amount'))
            //->select(['rp.*', 'l.name as lname', 'l.number as lnumber', 'l.commission_rate'])
            ->leftJoin('lawyer as l', 'rp.lawyer_id', '=', 'l.id');
        if ($lnum) {
            $note_monitor = $note_monitor->where("l.number", $lnum);
        }
        if ($lname) {
            $note_monitor = $note_monitor->where("l.name", $lname);
        }
        if ($year) {
            $note_monitor = $note_monitor->where("rp.year", $year);
        }
        if ($invoiced_at['start'] && $received_at['start']) {
            $in_start = $invoiced_at['start'] ?? '';
            $in_end = $invoiced_at['end'] ?? '';
            $re_start = $received_at['start'] ?? '';
            $re_end = $received_at['end'] ?? '';

            if ($in_start && $re_start) {
                if ($in_end && $re_end) {
                    $note_monitor = $note_monitor->whereBetween('rp.received_at', [$re_start, $re_end])
                        ->whereBetween('rp.invoiced_at', [$in_start, $in_end]);
                } else {
                    if ($in_end) {
                        $note_monitor = $note_monitor->whereDate('rp.received_at', '>', $re_start)
                            ->whereBetween('rp.invoiced_at', [$in_start, $in_end]);
                    } elseif ($re_end) {
                        $note_monitor = $note_monitor->whereDate('rp.invoiced_at', '>', $in_start)
                            ->whereBetween('rp.received_at', [$re_start, $re_end]);
                    } else {
                        $note_monitor = $note_monitor->whereDate('rp.invoiced_at', '>', $in_start)
                            ->whereDate('rp.received_at', '>', $re_start);
                    }
                }
            }
        } elseif ($invoiced_at['start'] && !$received_at['start']) { //开票日期
            $start = $invoiced_at['start'] ?? '';
            $end = $invoiced_at['end'] ?? '';

            if ($start) {
                if ($end) {
                    $note_monitor = $note_monitor->whereBetween('rp.received_at', [$start, $end]);
                } else {
                    $note_monitor = $note_monitor->whereDate('rp.received_at', '>', $start);
                }
            }
            //
        } elseif ($received_at['start'] && !$invoiced_at['start']) { //收款日期
            $start = $received_at['start'] ?? '';
            $end = $received_at['end'] ?? '';

            if ($start) {
                if ($end) {
                    $note_monitor = $note_monitor->whereBetween('rp.received_at', [$start, $end]);
                } else {
                    $note_monitor = $note_monitor->whereDate('rp.received_at', '>', $start);
                }
            }
        }

        // 获取列表
        $total = [
            'receipt_money' => 0,
            'invoiced_money' => 0,
            'commission_amount' => 0,
            'cost' => 0,
            'salary' => 0,
            'special_additional' => 0,
            'social' => 0,
            'accumulation_fund' => 0,
            'advance_fee' => 0,
            'tickets_money' => 0,
            'payable_commission' => 0,
        ];
        $list = $note_monitor->limit(1000)->groupBy('rp.lawyer_id')->get()->toArray();
        foreach ($list as $item) {
            $lawyerObj = Lawyer::find($item->lawyer_id);
            //已收款
            $receipt_money = $item->received_amount;
            $total['receipt_money'] += $receipt_money;
            //已开票
            $invoiced_money = $item->invoiced_money;
            $total['invoiced_money'] += $invoiced_money;
            //提成金额
            $commission_amount = self::getCommissionAmount($receipt_money, $lawyerObj->commission_rate);
            $total['commission_amount'] += $commission_amount;
            //成本合计
            $cost = LawyerCost::getTotalCost($item->lawyer_id, $year);
            $total['cost'] += $cost;
            //基本工资
            $salary = LawyerCost::getBasiSalary($item->lawyer_id, $year);
            $total['salary'] += $salary;
            //专项附加
            $additional = LawyerCost::getSpecialAdditional($item->lawyer_id, $year);
            $total['special_additional'] += $additional;
            //社保
            $social = LawyerCost::getSocial($item->lawyer_id, $year);
            $total['social'] += $social;
            //公积金
            $accumulation_fund = LawyerCost::getAccumulationFund($item->lawyer_id, $year);
            $total['accumulation_fund'] += $accumulation_fund;
            //预支款
            $advance_fee = LawyerCost::getAdvanceFee($item->lawyer_id, $year);
            $total['advance_fee'] += $advance_fee;
            //贴票金额
            $lawyerObj = Lawyer::find($item->lawyer_id);
            $tickets_money = LawyerCost::getPostingTicketsMoney($item->lawyer_id, $year, $lawyerObj->commission_rate, $lawyerObj->ticket_ratio);
            $total['tickets_money'] += $tickets_money;
            //可结算提成
            $payable_commission = self::getPayableAmount($item->lawyer_id, $year, $lawyerObj->commission_rate, $receipt_money);
            $total['payable_commission'] += $payable_commission;
        }
        return $total;
    }

    //提成金额
    public static function getCommissionAmount($receipt_money, $commission_rate)
    {
        return $receipt_money * ($commission_rate / 100);
    }
    //可结算提成
    public static function getPayableAmount($lawyer_id, $year, $commission_rate, $receipt_money)
    {
        $paid_amount =  LawyerCost::getPaidAmount($lawyer_id, $year); //已支付款项
        $result = $receipt_money * ($commission_rate / 100) - $paid_amount;
        return $result;
    }
}
