<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Response;

/**
 * api基类
 */
class BaseController extends Controller
{
    /**
     * @param $data mixed 返回的数据
     * @param $msg string 状态码
     * @param $code int 返回的自定义信息
     * @return Response
     */
    protected function JsonResponse($data, string $msg='Success', int $code=200) :Response {
        //组建返回结果
        $result = [
            'code' => $code,
            'message' => $msg,
            'data' => $data,
        ];
        return response($result, 200);
    }
}
