<?php

namespace App\Handlers;
use Intervention\Image\Facades\Image;
use Illuminate\Support\Str;

class FileUploadHandler
{
    // 只允许以下后缀名的图片文件上传
    protected $allowed_ext = ["png", "jpg", 'jpeg', 'pdf'];

    public function save($file)
    {
        $aliOss = new AilOss();

        // 获取上传的文件
        Image::make($file->getRealPath())
            ->resize(640, null, function ($constraint) {
                $constraint->aspectRatio();
                $constraint->upsize();
            })->encode('jpg', 90);

        $fileName = md5(uniqid()) . '.jpg';
        $date = date('Y_m_d');
        $ossFilePath = 'client/' . $date . '/' . $fileName;
        //获取文件的绝对路径
        $path = $file->getRealPath();
        $res = $aliOss->upload($ossFilePath, $path, 'OSS_PUBLIC_BUCKET');

        return $res ? env('OSS_PUBLIC_IMAGE_URL') . $ossFilePath : false;

    }
}
