<?php

use Illuminate\Routing\Router;
use Illuminate\Support\Facades\Route;
use Dcat\Admin\Admin;

Admin::routes();

Route::group([
    'prefix'     => config('admin.route.prefix'),
    'namespace'  => config('admin.route.namespace'),
    'middleware' => config('admin.route.middleware'),
], function (Router $router) {

    /******************************************************  图片文件上传组件Start  *********************************************************/

    $router->match(['put', 'post'], 'upload/delete-oss-file', 'UploadController@deleteOssFile'); //删除OSS私有资源文件

    $router->match(['put', 'post'], 'upload/delete-public-oss-file', 'UploadController@deletePublicOssFile'); //删除OSS公有资源文件

    $router->match(['put', 'post'], 'upload/user-avatar', 'UploadController@uploadUserAvatar'); //上传用户头像

    $router->match(['put', 'post'], 'upload/carousel', 'UploadController@uploadCarousel'); //上传轮播图

    $router->match(['put', 'post'], 'upload/resource-img', 'UploadController@uploadResourceImg'); //上传资源图

    $router->match(['put', 'post'], 'upload/resource-file', 'UploadController@uploadResourceFile'); //上传资源文件

    /******************************************************  图片文件上传组件end    *********************************************************/

    $router->get('/', 'HomeController@index');


    $router->resource('principal', 'PrincipalController'); //委托人信息

    $router->get('principal-list', 'PrincipalController@getList'); //委托人列表

    $router->resource('lawyer', 'LawyerController');  //律师信息

    $router->resource('covenant', 'CovenantController');  //合同信息

    $router->resource('lawyer_cost', 'LawyerCostController');  //律师成本表

    $router->resource('lycost-list', 'LawyerCostListController');  //律师成本明细

    $router->resource('lycost-collect', 'LawyerCostCollectController');  //律师成本汇总

    $router->resource('lawyer_income', 'LawyerIncomeController');  //律师创收表

    $router->resource('receive_payment', 'ReceivePaymentController');  //已收款/已开票汇总
    Route::get('received-invoiced-Export', 'ReceivePaymentController@receivedInvoicedExport'); //开票汇总导出

    $router->resource('lawyer-covenant-income', 'LawyerCovenantIncomeController');  //创收收款表

    $router->resource('view-covenant-received', 'ViewCovenantReceivedController');  //创收收款表--查看收款信息

    $router->resource('view-covenant-invoiced', 'ViewCovenantInvoicedController');  //创收收款表--查看开票信息

    $router->resource('lawyer_commission', 'LawyerCommissionController');  //律师提成表

    $router->resource('lawyer-commission-collect', 'LawyerCommissionCollectController');  //律师提成 查看汇总

    $router->resource('lawyer_collect', 'LawyerCollectController');  //律师汇总表

    $router->resource('covenant_receive_invoice', 'CovenantReceivePaymentController');  //开票收款汇总表





});
