<?php

use Dcat\Admin\Admin;
use Dcat\Admin\Grid;
use Dcat\Admin\Form;
use Dcat\Admin\Grid\Filter;
use Dcat\Admin\Show;

/**
 * Dcat-admin - admin builder based on Laravel.
 * @author jqh <https://github.com/jqhph>
 *
 * Bootstraper for Admin.
 *
 * Here you can remove builtin form field:
 *
 * extend custom field:
 * Dcat\Admin\Form::extend('php', PHPEditor::class);
 * Dcat\Admin\Grid\Column::extend('php', PHPEditor::class);
 * Dcat\Admin\Grid\Filter::extend('php', PHPEditor::class);
 *
 * Or require js and css assets:
 * Admin::css('/packages/prettydocs/css/styles.css');
 * Admin::js('/packages/prettydocs/js/main.js');
 *
 */

use Dcat\Admin\Layout\Navbar;

admin_inject_section(Admin::SECTION['NAVBAR_USER_PANEL'], function () {
    return view('admin.partials.navbar-user-panel', ['user' => Admin::user()]);
});

Admin::navbar(function (Navbar $navbar) {
    $navbar->left('<div class="navbar-header">
    <ul class="nav navbar-nav flex-row">
        <li class="nav-item mr-auto">
            <a href="/" class="navbar-brand waves-effect waves-light">
                <span class="logo-lg"><img src="/vendor/dcat-admin/images/logo.jpg" width="40"> &nbsp;律所管理系统</span>
            </a>
        </li>
    </ul>
</div>');
});
