<?php

namespace App\Admin\Repositories;

use App\Models\CovenantReceivePayment as ModelsCovenantReceivePayment;
use Dcat\Admin\Repositories\EloquentRepository;
use Dcat\Admin\Grid;
use Illuminate\Support\Facades\DB;

class LawyerInvoicedPaymentCollect extends EloquentRepository
{
    /**
     * Model.
     *
     * @var string
     */
    protected $eloquentClass = ModelsCovenantReceivePayment::class;


    public function get(Grid\Model $model)
    {
        // 获取筛选条件
        $year = $model->filter()->input('year');
        $lawyer_id = $model->filter()->input('no');
        $param = [
            'search'   => [
                'year' => $year,
                'lawyer_id' => $lawyer_id
            ]
        ];

        $data = $this->getList($param);
        return $data;
    }

    // 获取列表数据
    public function getList(array $param)
    {

        $year = $param['search']['year'] ?? '';
        $lawyer_id = $param['search']['lawyer_id'] ?? 0;
        $nowyear = date("Y");
        $monthNum = ($year && $year < $nowyear)  ? 12 : date('m');

        $data = [];
        for ($i = 1; $i <= $monthNum; $i++) {
            $received_amount = ModelsCovenantReceivePayment::where(['rtype' => 2, 'lawyer_id' => $lawyer_id, 'year' => $year, 'month' => $i])->sum('invoiced_money');
            $data[$i] = $received_amount;
        }

        return [$data];
    }
}
