<?php

namespace App\Admin\Repositories;

use App\Models\Lawyer as ModelLawyer;
use App\Models\LawyerCost as ModelLawyerCost;
use App\Models\CovenantReceivePayment as ModelCovenantReceivePayment;
//use Dcat\Admin\Repositories\EloquentRepository;
use Dcat\Admin\Repositories\Repository;
use Dcat\Admin\Grid;

use Illuminate\Support\Collection;

class LawyerCommission extends Repository
{
    /**
     * Model.
     *
     * @var string
     */
    //protected $eloquentClass = Model::class;


    /**
     * 
     * 
     */
    public function get(Grid\Model $model)
    {
        // 获取筛选条件
        $year = $model->filter()->input('year') ?? date("Y");
        $lnum = $model->filter()->input('no') ?? '';
        $lawyer_id = $commission_rate = $ticket_ratio = 0;
        if ($lnum) {
            $larwerObj = ModelLawyer::where('number', $lnum)->first();
            $lawyer_id = $larwerObj->id;
            $commission_rate = $larwerObj->commission_rate;
            $ticket_ratio = $larwerObj->ticket_ratio;
        }

        $data = [];
        $nowyear = date('Y');
        $monthNum = $year >= $nowyear ? date('m') : 12;

        $fieldTotal = 0;
        $list = ModelLawyerCost::CommissioniTEM; //Lawyer::all();
        foreach ($list as $key => $val) {

            $tmp = [];
            $tmp['title'] = $val['name']; //项目名称
            //总计
            $tmp['total'] = 0;


            for ($i = 1; $i <= $monthNum; $i++) {
                $tmp[$i] = '0.00';

                $condition = ['year' => $year, 'month' => $i, 'number' => $lnum];
                //创收收款
                $receiveMoeny = ModelCovenantReceivePayment::getReceivedMoney($lawyer_id, $year, $i);
                if ($val['field'] == 'received_money') {
                    $tmp[$i] = ModelCovenantReceivePayment::getReceivedMoney($lawyer_id, $year, $i);
                }
                //提成比例
                if ($val['field'] == 'commission_rate') {
                    $tmp[$i] = strval($commission_rate * 1) . '%';
                }
                //可提成金额
                $royalty_amount = 0;
                if ($val['field'] == 'royalty_amount') {
                    $royalty_amount = sprintf('%.2f', $receiveMoeny * ($commission_rate / 100));
                    $tmp[$i] = $royalty_amount;
                }
                //已支付款项
                $paid_amount = 0;
                if ($val['field'] == 'paid_amount') {
                    $paid_amount = ModelLawyerCost::getPaidAmount($lawyer_id, $year, $i);
                    $tmp[$i] = sprintf('%.2f', $paid_amount);
                }
                //基本工资
                if ($val['field'] == 'basic_salary') {
                    $basic_salary = ModelLawyerCost::where($condition)->sum('basic_salary');
                    $tmp[$i] = $basic_salary;
                    $fieldTotal += $basic_salary;
                }

                //专项附加
                if ($val['field'] == 'special_additional') {
                    $special_additional = ModelLawyerCost::where($condition)->sum('special_additional');
                    $tmp[$i] = $special_additional;
                    $fieldTotal += $special_additional;
                }
                //社保
                if ($val['field'] == 'social') {
                    $social_person_fee = ModelLawyerCost::where($condition)->sum('social_person_fee');
                    $social_company_fee = ModelLawyerCost::where($condition)->sum('social_company_fee');
                    $tmp[$i] = sprintf("%.2f", ($social_person_fee + $social_company_fee));
                }
                //社保个人部分
                if ($val['field'] == 'social_person_fee') {
                    $social_person_fee = ModelLawyerCost::where($condition)->sum('social_person_fee');
                    $tmp[$i] = $social_person_fee;
                }
                //社保企业部分
                if ($val['field'] == 'social_company_fee') {
                    $social_company_fee = ModelLawyerCost::where($condition)->sum('social_company_fee');
                    $tmp[$i] = $social_company_fee;
                }
                //公积金
                if ($val['field'] == 'accumulation_fund') {
                    $person_fee = ModelLawyerCost::where($condition)->sum('accumulation_fund_person_fee');
                    $company_fee = ModelLawyerCost::where($condition)->sum('accumulation_fund_company_fee');
                    $tmp[$i] = sprintf("%.2f", ($person_fee + $company_fee));
                }
                //公积金个人部分
                if ($val['field'] == 'accumulation_fund_person_fee') {
                    $person_fee = ModelLawyerCost::where($condition)->sum('accumulation_fund_person_fee');
                    $tmp[$i] = sprintf("%.2f", $person_fee);
                }
                //公积金企业部分 
                if ($val['field'] == 'accumulation_fund_company_fee') {
                    $company_fee = ModelLawyerCost::where($condition)->sum('accumulation_fund_company_fee');
                    $tmp[$i] = sprintf("%.2f", $company_fee);
                }
                //律所年检费 
                if ($val['field'] == 'annual_inspection_fee') {
                    $annual_inspection_fee = ModelLawyerCost::where($condition)->sum('annual_inspection_fee');
                    $tmp[$i] = $annual_inspection_fee;
                }
                //律所年金 
                if ($val['field'] == 'annuity') {
                    $annuity = ModelLawyerCost::where($condition)->sum('annuity');
                    $tmp[$i] = $annuity;
                }

                //办公室租赁成本  
                if ($val['field'] == 'office_rental_fee') {
                    $office_rental_fee = ModelLawyerCost::where($condition)->sum('office_rental_fee');
                    $tmp[$i] = $office_rental_fee;
                }

                //助理律师成本 
                if ($val['field'] == 'assistant_fee') {
                    $assistant_fee = ModelLawyerCost::where($condition)->sum('assistant_fee');
                    $tmp[$i] = $assistant_fee;
                }


                //预支款
                if ($val['field'] == 'advance_fee') {
                    $advance_fee = ModelLawyerCost::where($condition)->sum('advance_fee');
                    $tmp[$i] = $advance_fee;
                }
                //预留结案费 
                if ($val['field'] == 'reserved_closing_fee') {
                    $reserved_closing_fee =  $receiveMoeny * ($commission_rate / 100) * 0.05;
                    $tmp[$i] = sprintf('%.2f', $reserved_closing_fee);
                }
                //贴票金额
                if ($val['field'] == 'posting_tickets_money') {
                    $tickets_money = ModelLawyerCost::getPostingTicketsMoney($lawyer_id, $year, $commission_rate, $ticket_ratio, $i);
                    $tmp[$i] = sprintf('%.2f', $tickets_money);
                }
                //提成留底 
                if ($val['field'] == 'commission_retention') {
                    $tmp[$i] = '4万';
                }
                //可支付提成结算金额
                if ($val['field'] == 'payable_commission_amount') {
                    $payable_money = $royalty_amount - $paid_amount;
                    $tmp[$i] = $payable_money;
                }
                //个人所得税  
                if ($val['field'] == 'personal_income_tax') {
                    $personal_income_tax = ModelLawyerCost::where($condition)->sum('personal_income_tax');
                    $tmp[$i] = $personal_income_tax;
                }

                //总计
                if (!in_array($val['field'], ['commission_rate', 'commission_retention'])) {
                    $tmp['total'] += $tmp[$i];
                }
            }

            $data[$key] = $tmp;
        }

        return $data;
    }
}
