<?php

namespace App\Admin\Repositories;

use App\Models\Covenant as ModelsCovenant;
use App\Models\LawyerCost as ModelsLawyerCost;
use App\Models\Lawyer as ModelsLawyer;
use App\Models\CovenantReceivePayment as ModelCovenantReceivePayment;
use App\Models\Principal;
use Dcat\Admin\Repositories\EloquentRepository;
use Dcat\Admin\Grid;
use Illuminate\Support\Facades\DB;

class LawyerCollect extends EloquentRepository
{
    /**
     * Model.
     *
     * @var string
     */
    protected $eloquentClass = ModelsCovenant::class;


    public function get(Grid\Model $model)
    {
        // 获取当前页数
        $currentPage = $model->getCurrentPage();
        // 获取每页显示行数
        $perPage = $model->getPerPage();

        $start = ($currentPage - 1) * $perPage;

        // 获取排序参数, 格式例如['id', 'asc', null]
        $sort = $model->getSort();

        // 获取筛选条件
        $number = $model->filter()->input('number');
        $lname = $model->filter()->input('name');
        $year = $model->filter()->input('year') ?? date("Y");
        $received_at = $invoiced_at = [];
        $received_at['start'] = isset($_GET['received_at']['start']) && $_GET['received_at']['start'] ? $_GET['received_at']['start'] . "-01" : '';
        $received_at['end'] = isset($_GET['received_at']['end']) && $_GET['received_at']['end'] ? $_GET['received_at']['end'] . "-31" : '';
        $invoiced_at['start'] = isset($_GET['invoiced_at']['start']) && $_GET['invoiced_at']['start']  ? $_GET['invoiced_at']['start'] . '-01' : '';
        $invoiced_at['end'] = isset($_GET['invoiced_at']['end']) && $_GET['invoiced_at']['end'] ? $_GET['invoiced_at']['end'] . '-31' : '';


        $param = [
            'sort'     => $sort,
            'offsetstart'     => $start,
            'search'   => [
                'number' => $number,
                'lname' => $lname,
                'year' => $year,
                'invoiced_at' => $invoiced_at,
                'received_at' => $received_at,
            ]
        ];

        $data = $this->getList($param);

        return $model->makePaginator(
            $data['total'] ?? 0, // 传入总记录数
            $data['subjects'] ?? [] // 传入数据二维数组
        );
    }

    // 获取列表数据
    public function getList(array $param)
    {
        $prePage = $param['per_page'] ?? 20;
        $offsetstart = $param['offsetstart'] ?? 0;
        $number = $param['search']['number'] ?? '';
        $lname = $param['search']['lname'] ?? '';
        $year = $param['search']['year'] ?? date("Y");
        $invoiced_at = $param['search']['invoiced_at'] ?? [];
        $received_at = $param['search']['received_at'] ?? [];

        $list = [];
        $note_monitor = DB::table('covenant_receive_payment AS rp')
            ->select(DB::raw('rp.lawyer_id,rp.year,l.number as lnumber,l.name as lname,l.commission_rate,sum(invoiced_money) as invoiced_money,sum(received_amount) as received_amount'))
            //->select(['rp.*', 'l.name as lname', 'l.number as lnumber', 'l.commission_rate'])
            ->leftJoin('lawyer as l', 'rp.lawyer_id', '=', 'l.id');
        if ($number) {
            $note_monitor = $note_monitor->where("l.number", $number);
        }
        if ($lname) {
            $note_monitor = $note_monitor->where("l.name", $lname);
        }
        if ($year) {
            $note_monitor = $note_monitor->where("rp.year", $year);
        }

        if ($invoiced_at['start'] && $received_at['start']) {
            $in_start = $invoiced_at['start'] ?? '';
            $in_end = $invoiced_at['end'] ?? '';
            $re_start = $received_at['start'] ?? '';
            $re_end = $received_at['end'] ?? '';
            if ($in_start && $re_start) {
                if ($in_end && $re_end) {
                    $note_monitor = $note_monitor->whereBetween('rp.received_at', [$re_start, $re_end])
                        ->whereBetween('rp.invoiced_at', [$in_start, $in_end]);
                } else {
                    if ($in_end) {
                        $note_monitor = $note_monitor->whereDate('rp.received_at', '>', $re_start)
                            ->whereBetween('rp.invoiced_at', [$in_start, $in_end]);
                    } elseif ($re_end) {
                        $note_monitor = $note_monitor->whereDate('rp.invoiced_at', '>', $in_start)
                            ->whereBetween('rp.received_at', [$re_start, $re_end]);
                    } else {
                        $note_monitor = $note_monitor->whereDate('rp.invoiced_at', '>', $in_start)
                            ->whereDate('rp.received_at', '>', $re_start);
                    }
                }
            }
        } elseif ($invoiced_at['start'] && !$received_at['start']) { //开票日期
            $start = $invoiced_at['start'] ?? '';
            $end = $invoiced_at['end'] ?? '';

            if ($start) {
                if ($end) {
                    $note_monitor = $note_monitor->whereBetween('rp.received_at', [$start, $end]);
                } else {
                    $note_monitor = $note_monitor->whereDate('rp.received_at', '>', $start);
                }
            }
            //
        } elseif ($received_at['start'] && !$invoiced_at['start']) { //收款日期
            $start = $received_at['start'] ?? '';
            $end = $received_at['end'] ?? '';

            if ($start) {
                if ($end) {
                    $note_monitor = $note_monitor->whereBetween('rp.received_at', [$start, $end]);
                } else {
                    $note_monitor = $note_monitor->whereDate('rp.received_at', '>', $start);
                }
            }
        }
        // 计算列表总数
        $count = $note_monitor->count();
        // 获取列表
        $data = [];
        $list = $note_monitor->limit($prePage)->offset($offsetstart)->groupBy('rp.lawyer_id')->get()->toArray();


        foreach ($list as $key => $item) {
            $tmp = [];
            //$tmp['id'] = $item->id;
            //已收款
            $receipt_money = $item->received_amount; //ModelCovenantReceivePayment::getReceivedMoney($item->lawyer_id, $year);
            //已开票
            $invoiced_money = $item->invoiced_money; //ModelCovenantReceivePayment::getInvoicedMoney($item->lawyer_id, $year);
            //已收款未开票
            $receipt_noinvoice = ($receipt_money - $invoiced_money) > 0 ? $receipt_money - $invoiced_money : 0;
            //已开票未收款
            $invoice_noreceipt = ($invoiced_money - $receipt_money) > 0 ? $invoiced_money - $receipt_money : 0;
            //贴票金额
            $lawyerObj = ModelsLawyer::find($item->lawyer_id);
            $tickets_money = ModelsLawyerCost::getPostingTicketsMoney($item->lawyer_id, $year, $lawyerObj->commission_rate, $lawyerObj->ticket_ratio);

            $tmp['lnumber'] = $item->lnumber;
            $tmp['lname'] = $item->lname;
            $tmp['commission_ratio'] = $item->commission_rate;
            $tmp['receipt_money'] = $receipt_money;
            $tmp['commission_amount'] = self::getCommissionAmount($receipt_money, $item->commission_rate);
            $tmp['receipt_noinvoice'] = $receipt_noinvoice;
            $tmp['invoice_noreceipt'] = $invoice_noreceipt;
            $tmp['cost'] = ModelsLawyerCost::getTotalCost($item->lawyer_id, $year);
            $tmp['basic_salary'] = ModelsLawyerCost::getBasiSalary($item->lawyer_id, $year);
            $tmp['special_additional'] = ModelsLawyerCost::getSpecialAdditional($item->lawyer_id, $year);
            $tmp['social'] = ModelsLawyerCost::getSocial($item->lawyer_id, $year);
            $tmp['accumulation_fund'] = ModelsLawyerCost::getAccumulationFund($item->lawyer_id, $year);
            $tmp['posting_tickets_fee'] = $tickets_money;
            $tmp['advance_fee'] = ModelsLawyerCost::getAdvanceFee($item->lawyer_id, $year);
            $tmp['payable_commission'] = self::getPayableAmount($item->lawyer_id, $year, $item->commission_rate, $receipt_money);
            array_push($data, $tmp);
        }

        return [
            'total' => $count,
            'subjects' => $data
        ];
    }

    public static function getPayableAmount($lawyer_id, $year, $commission_rate, $receipt_money)
    {
        $paid_amount =  ModelsLawyerCost::getPaidAmount($lawyer_id, $year); //已支付款项
        $result = $receipt_money * ($commission_rate / 100) - $paid_amount;
        return sprintf('%.2f', $result);
    }
    //提成金额
    public static function getCommissionAmount($receipt_money, $commission_rate)
    {
        $result = $receipt_money * ($commission_rate / 100);
        return sprintf('%.2f', $result);
    }
}
