<?php

namespace App\Admin\Forms;

use App\Models\User;
use Dcat\Admin\Widgets\Form;
use Dcat\Admin\Contracts\LazyRenderable;
use Dcat\Admin\Traits\LazyWidget;
use Illuminate\Support\Facades\DB;

class TruncateTable extends Form implements LazyRenderable
{
    use LazyWidget;

    /**
     * Handle the form request.
     *
     * @param array $input
     *
     * @return mixed
     */
    public function handle(array $input)
    {
        $status = (int)$input['status'];
        $tablename = trim($this->payload['tablename']);

        if ($status == 1 && $tablename) {
            DB::table($tablename)->truncate(); // 清空数据表
        }

        return $this->response()->success('确认成功')->refresh();
    }

    /**
     * Build a form here.
     */
    public function form()
    {
        $this->radio('status', '清空状态')->options([1 => '是', 0 => '否'])->default(0)->required();
    }

    /**
     * The data of the form.
     *
     * @return array
     */
    public function default()
    {
        // 获取外部传递参数
        return [];
    }
}
