<?php

namespace App\Admin\Forms;

use App\Imports\ImportExcel as uImportExcel;
use App\Jobs\ansyImportExcel;
use Dcat\Admin\Contracts\LazyRenderable;
use Dcat\Admin\Traits\LazyWidget;
use Dcat\Admin\Widgets\Form;


class ImportExcel extends Form  implements LazyRenderable
{
    use LazyWidget;
    /**
     * Handle the form request.
     *
     * @param array $input
     *
     * @return mixed
     */
    public function handle(array $input)
    {

        $file_path = storage_path('app/public' . $input['e_file']);

        dispatch(new ansyImportExcel($this->payload['className'], $file_path));
        return $this
            ->response()
            ->success('导入成功，请稍后刷新页面查看数据.')
            ->refresh();
    }

    /**
     * Build a form here.
     */
    public function form()
    {

        $this->file('e_file', '数据文件')
            ->disk('public')
            ->accept('xls,xlsx')
            ->uniqueName()
            ->move('/import')
            ->autoUpload()
            ->help('仅支持xls,xlsx格式文件上传')
            ->required();
    }

    /**
     * The data of the form.
     *
     * @return array
     */
    public function default()
    {
        return [
            'name'  => 'John Doe',
            'email' => 'John.Doe@gmail.com',
        ];
    }
}
