<?php

namespace App\Admin\Forms;

use App\Command\Log;
use Dcat\Admin\Widgets\Form;
use Dcat\Admin\Contracts\LazyRenderable;
use Dcat\Admin\Traits\LazyWidget;
use Exception;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Request;
use App\Models\Covenant as ModelsCovenant;

class CovenantReturnForm extends Form implements LazyRenderable
{
    use LazyWidget;

    /**
     * Handle the form request.
     *
     * @param array $input
     *
     * @return mixed
     */
    public function handle(array $input)
    {
        $cid = $this->payload['cid'];
        DB::beginTransaction();
        try {
            $return_fee = floatval($input['return_fee']);
            $uObj = ModelsCovenant::find($cid);
            if ($uObj && $uObj->is_return == 0 && $return_fee) {
                $uObj->is_return = 1;
                $uObj->return_fee = $return_fee;
                $uObj->save();
            }
            DB::commit();
        } catch (\Exception $exception) {
            DB::rollBack();
            return $this->response()->error($exception->getMessage())->refresh();
        }
        return $this->response()->success('提交成功' . $cid)->refresh();
    }


    /**
     * Build a form here.
     */
    public function form()
    {
        $this->text('return_fee', '退还结案费')->required();
    }

    /**
     * The data of the form.
     *
     * @return array
     */
    public function default()
    {
        // 获取外部传递参数
        return [];
    }
}
