<?php

namespace App\Admin\Forms;

use App\Command\Log;
use Dcat\Admin\Widgets\Form;
use Dcat\Admin\Contracts\LazyRenderable;
use Dcat\Admin\Traits\LazyWidget;
use Exception;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Request;
use App\Models\Covenant as ModelsCovenant;
use App\Models\CovenantReceivePayment as ModelsCovenantReceivePayment;

class CovenantReceiveForm extends Form implements LazyRenderable
{
    use LazyWidget;

    /**
     * Handle the form request.
     *
     * @param array $input
     *
     * @return mixed
     */
    public function handle(array $input)
    {
        $cid = $this->payload['cid']; //合同ID
        DB::beginTransaction();
        try {
            $received_type = (int)$input['received_type'];
            $pay_method = trim($input['pay_method']);
            $received_at = trim($input['received_at']);
            $received_amount = trim($input['received_amount']);
            $paymenter = trim($input['paymenter']);
            $datearr = explode('-', $received_at);
            $year = $datearr[0];
            $month = $datearr[1];

            $cObj = ModelsCovenant::find($cid);
            if (!$cObj) {
                throw new Exception('该合同不存在！');
            }

            $receivePaymentObj = new ModelsCovenantReceivePayment();
            $receivePaymentObj->received_type = $received_type;
            $receivePaymentObj->pay_method = $pay_method;
            $receivePaymentObj->received_at = $received_at;
            $receivePaymentObj->received_amount = $received_amount;
            $receivePaymentObj->paymenter = $paymenter;
            $receivePaymentObj->cid = $cid;
            $receivePaymentObj->lawyer_id = $cObj->lawyer_id;
            $receivePaymentObj->principal = $cObj->principal;
            $receivePaymentObj->year = $year;
            $receivePaymentObj->month = $month;
            $receivePaymentObj->rtype = 1;
            $receivePaymentObj->save();

            DB::commit();
        } catch (\Exception $exception) {
            DB::rollBack();
            return $this->response()->error($exception->getMessage())->refresh();
        }
        return $this->response()->success('提交成功')->refresh();
    }


    /**
     * Build a form here.
     */
    public function form()
    {
        $this->select('received_type', '收款账户')->options([1 => '基本户', 2 => '其它'])->required();
        $this->text('pay_method', '支付方式')->required();
        $this->date('received_at', '收款时间')->format('YYYY-MM-DD')->default(date("Y-m-d"))->required();
        $this->text('received_amount', '收款金额')->required();
        $this->text('paymenter', '付款人');
    }

    /**
     * The data of the form.
     *
     * @return array
     */
    public function default()
    {
        // 获取外部传递参数
        return [];
    }
}
