<?php

namespace App\Admin\Controllers;

use App\Models\Principal as ModelsPrincipal;
use App\Models\Covenant as ModelsCovenant;
use App\Models\CovenantReceivePayment as ModelsCovenantReceivePayment;
use Dcat\Admin\Form;
use Dcat\Admin\Grid;
use Dcat\Admin\Show;
use Dcat\Admin\Http\Controllers\AdminController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Dcat\Admin\Layout\Content;
use Dcat\Admin\Widgets\Modal;
use App\Admin\Forms\CovenantReceiveForm;
use App\Models\Lawyer as ModelsLawyer;
use Dcat\Admin\Admin;

class ViewCovenantReceivedController extends AdminController
{
    /**
     * 查看收款信息
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
        return Grid::make(new ModelsCovenantReceivePayment(), function (Grid $grid) {
            $cid = $grid->model()->filter()->input('cid') ?? 0;
            $lawyer_id = 0;
            if ($cid) {
                $cobj = ModelsCovenant::find($cid);
                $lawyer_id = $cobj->lawyer_id;
            }

            $grid->tools(function (Grid\Tools $tools) use ($cid) {
                if (Admin::user()->can('view-received-add')) {
                    $tools->append(Modal::make()
                        // 大号弹窗
                        ->lg()
                        // 弹窗标题
                        ->title('新增')
                        // 按钮
                        ->button('<button class="btn btn-primary"><i class="feather icon-plus"></i> 新增</button>')
                        // 弹窗内容
                        ->body(CovenantReceiveForm::make()->payload(['cid' => $cid])));
                }
            });


            $grid->model()->where(['rtype' => 1, 'lawyer_id' => $lawyer_id, 'cid' => $cid])->orderBy("id", "desc");
            //$grid->column('id')->sortable();
            $grid->column('received_type', '收款账户')->display(function ($val) {
                return $val == 1 ? '基本户' : '其它';
            });
            $grid->column('pay_method', '支付方式');
            $grid->column('received_at', '收款时间');
            $grid->column('received_amount', '收款金额');
            $grid->column('paymenter', '付款人');

            $grid->disableViewButton();
            $grid->disableCreateButton();
            $grid->disableRowSelector();

            //文字信息
            $grid->tools(function (Grid\Tools $tools) use ($grid, $cid) {
                $principal = $cnumber = $lnumber = $lname = '';
                $invoiced_money = $received_money = $received_noinvoiced = $invoiced_noreceived = 0;
                if ($cid) {
                    $cobj = ModelsCovenant::find($cid);
                    $principal = $cobj->principal;
                    $cnumber = $cobj->number;
                    $lobj = ModelsLawyer::find($cobj->lawyer_id);
                    $lnumber = $lobj->number;
                    $lname = $lobj->name;
                    //开票金额
                    $invoiced_money = self::getInvoicedByCid($cid);
                    //已收款
                    $received_money = self::getReceivedByCid($cid);
                    //已收款未开票
                    $received_noinvoiced = ($received_money - $invoiced_money) > 0 ? $received_money - $invoiced_money : 0;
                    //已开票未收款
                    $invoiced_noreceived = ($invoiced_money - $received_money) > 0 ? $invoiced_money - $received_money  : 0;
                }
                $card_info = "&nbsp;&nbsp;合同编号：{$cnumber}&nbsp;&nbsp;&nbsp;委托人：{$principal}";
                $card_info .= "&nbsp;&nbsp;律师编号：{$lnumber}&nbsp;&nbsp;&nbsp;律师姓名：{$lname}";
                $card_info .= "&nbsp;&nbsp;开票金额：{$invoiced_money}&nbsp;&nbsp;&nbsp;已收款：{$received_money}";
                $card_info .= "&nbsp;&nbsp;已收款未开票：{$received_noinvoiced}&nbsp;&nbsp;&nbsp;已开票未收款：{$invoiced_noreceived}";
                $tools->append($card_info);
            });

            $grid->actions(function (Grid\Displayers\Actions $actions) {
                //编辑
                if (!Admin::user()->can('view-received-edit')) {
                    $actions->disableEdit();
                }
                //删除
                if (!Admin::user()->can('view-received-delete')) {
                    $actions->disableDelete();
                }
            });
        });
    }


    /**
     * Make a form builder.
     *
     * @return Form
     */
    protected function form()
    {
        $form = Form::make(new ModelsCovenantReceivePayment(), function (Form $form) {
            //$form->display('id');
            $form->select('received_type', '账户类型')->options(ModelsCovenantReceivePayment::RECEIVEDTYPE);
            $form->text('pay_method', '支付方式');
            $form->date('received_at', '收款时间')->format('YYYY-MM-DD');
            $form->text('received_amount', '收款金额');
            $form->text('paymenter', '付款人');

            $form->disableCreatingCheck();
            $form->disableEditingCheck();
            $form->disableViewCheck();
            $form->disableDeleteButton();
            $form->disableViewButton();
            $form->disableListButton();
        });

        return $form;
    }

    //开票金额
    public static function getInvoicedByCid($cid)
    {
        return ModelsCovenantReceivePayment::where(['cid' => $cid, 'rtype' => 2])->sum('invoiced_money');
    }

    //已收款 
    public static function getReceivedByCid($cid)
    {
        return ModelsCovenantReceivePayment::where(['cid' => $cid, 'rtype' => 1])->sum('received_amount');
    }
}
