<?php
namespace App\Admin\Controllers;

use App\Handlers\AilOss;

use Dcat\Admin\Traits\HasUploadedFile;
use Intervention\Image\Facades\Image;

class UploadController{

    use HasUploadedFile;

    /**
     * 删除OSS私有桶资源文件
     */
    public function deleteOssFile(){
        $ossPath = request()->post('key') ?? '';
        $aliOss = new AilOss();
        $res = $aliOss->delete($ossPath);
        return $res ? $this->responseDeleted() : $this->responseDeleteFailed('文件删除失败');
    }

    /**
     * 删除OSS公有桶资源文件
     */
    public function deletePublicOssFile(){
        $ossPath = request()->post('key') ?? '';
        $aliOss = new AilOss();
        $res = $aliOss->delete($ossPath,'OSS_PUBLIC_BUCKET');
        return $res ? $this->responseDeleted() : $this->responseDeleteFailed('文件删除失败');
    }

    /**
     * 上传用户头像
     */
    public function uploadUserAvatar()
    {
        $aliOss = new AilOss();

        // 获取上传的文件
        $file = $this->file();;
        //获取文件扩展名
        $file = $this->file();;
        Image::make($file->getRealPath())
            ->resize(640, null, function ($constraint) {
                $constraint->aspectRatio();
                $constraint->upsize();
            })->encode('jpg', 90);

        $fileName = md5(uniqid()) . '.jpg';
        $date = date('Y_m_d');
        $ossFilePath =  'userAvatar/'.$date.'/'.$fileName;
        //获取文件的绝对路径
        $path = $file->getRealPath();
        $res = $aliOss->upload($ossFilePath, $path,'OSS_PUBLIC_BUCKET');

        return $res
            ? $this->responseUploaded(env('OSS_PUBLIC_IMAGE_URL').$ossFilePath,'')
            : $this->responseErrorMessage('文件上传失败');
    }


    /**
     * 上传轮播图
     */
    public function uploadCarousel()
    {
        $aliOss = new AilOss();

        // 获取上传的文件
        $file = $this->file();;
        Image::make($file->getRealPath())
            ->resize(640, null, function ($constraint) {
                $constraint->aspectRatio();
                $constraint->upsize();
            })->encode('jpg', 90);

        $fileName = md5(uniqid()) . '.jpg';
        $date = date('Y_m_d');
        $ossFilePath =  'Carousel/'.$date.'/'.$fileName;
        //获取文件的绝对路径
        $path = $file->getRealPath();
        $res = $aliOss->upload($ossFilePath, $path,'OSS_PUBLIC_BUCKET');

        return $res
            ? $this->responseUploaded(env('OSS_PUBLIC_IMAGE_URL').$ossFilePath,'')
            : $this->responseErrorMessage('文件上传失败');
    }


    /**
     * 上传资源库图片
     */
    public function uploadResourceImg()
    {
        $aliOss = new AilOss();

        // 获取上传的文件
        $file = $this->file();;
        Image::make($file->getRealPath())
            ->resize(640, null, function ($constraint) {
                $constraint->aspectRatio();
                $constraint->upsize();
            })->encode('jpg', 90);

        $fileName = md5(uniqid()) . '.jpg';
        $date = date('Y_m_d');
        $ossFilePath =  'ResourceImg/'.$date.'/'.$fileName;
        //获取文件的绝对路径
        $path = $file->getRealPath();
        $res = $aliOss->upload($ossFilePath, $path,'OSS_PUBLIC_BUCKET');

        return $res
            ? $this->responseUploaded(env('OSS_PUBLIC_IMAGE_URL').$ossFilePath,'')
            : $this->responseErrorMessage('文件上传失败');
    }
    
     //上传资源文件
    public function uploadResourceFile()
    {
        $aliOss = new AilOss();

        // 获取上传的文件
        $file = $this->file();;
        //获取文件扩展名
        $ext = $file->getClientOriginalExtension();
        $fileName = uniqid().'.'.$ext;
        $date = date('Y_m_d');
        $ossFilePath =  'ResourceFile/'.$date.'/'.$fileName;
        //获取文件的绝对路径
        $path = $file->getRealPath();
        $res = $aliOss->upload($ossFilePath, $path,'OSS_PUBLIC_BUCKET');


        return $res
            ? $this->responseUploaded(env('OSS_PUBLIC_IMAGE_URL').$ossFilePath,'')
            : $this->responseErrorMessage('文件上传失败');
    }
}
