<?php

namespace App\Admin\Controllers;

use App\Admin\Metrics\Examples;
use App\Http\Controllers\Controller;
use App\Models\Covenant;
use App\Models\Lawyer;
use Dcat\Admin\Http\Controllers\Dashboard;
use Dcat\Admin\Layout\Column;
use Dcat\Admin\Layout\Content;
use Dcat\Admin\Layout\Row;
use Dcat\Admin\Widgets\Tab;
use Dcat\Admin\Grid;
use App\Models\Lawyer as ModelsLawyer;
use App\Models\CovenantReceivePayment as ModelCovenantReceivePayment;
use App\Admin\Repositories\LawyerReceivePaymentCollect;
use App\Admin\Repositories\LawyerInvoicedPaymentCollect;
use App\Admin\Actions\ReceivedInvoicedExcel;
use Illuminate\Http\Request;
use Maatwebsite\Excel\Facades\Excel;
use App\Admin\Extensions\ReceivedInvoicedExport;

class ReceivePaymentController extends Controller
{
    public function index(Content $content)
    {
        // 创建第一个数据列表 已收款汇总表
        $grid1 = Grid::make(new LawyerReceivePaymentCollect(), function (Grid $grid) {
            $lawyerID = $grid->model()->filter()->input('no') ?? ''; //律师ID
            $nowyear = date("Y");
            $year = $grid->model()->filter()->input('year') ?? date('Y');
            $monthNum = ($year && $year < $nowyear)  ? 12 : date('m');

            for ($i = 1; $i <= $monthNum; $i++) {
                $grid->column($i, $i . '月');
            }

            $grid->disableActions();
            $grid->disableViewButton();
            $grid->disableCreateButton();
            $grid->disableRowSelector();
            $grid->disablePagination();

            $grid->filter(function (Grid\Filter $filter) {
                // 更改为 panel 布局
                $filter->panel();
                $filter->like('year', '年份')->width(3)->default(date("Y"))->ignore();
            });

            //文字信息
            $grid->tools(function (Grid\Tools $tools) use ($grid, $lawyerID, $year) {
                //导出按钮
                // 获取筛选条件
                $param = [
                    'search'   => ['lawyer_id' => $lawyerID, 'year' => $year, 'rtype' => 1]
                ];
                // 导出
                $filename = '已收款汇总表';
                $tools->append(new ReceivedInvoicedExcel($param, $filename, '导出'));
                //文字展示
                $fullname = $number = '';
                if ($lawyerID) {
                    $obj = ModelsLawyer::find($lawyerID);
                    $fullname = $obj->name;
                    $number = $obj->number;
                }
                $card_info = "&nbsp;&nbsp;律师编号：{$number}&nbsp;&nbsp;&nbsp;律师姓名：{$fullname}";

                $tools->append($card_info);
            });

            // $grid->export()->disableExportAll();
            // $grid->export()->disableExportSelectedRow();
            // $grid->export()->rows(function ($rows) {
            //     return $rows;
            // });
        });


        // 创建第二个数据列表
        $grid2 = Grid::make(new LawyerInvoicedPaymentCollect(), function (Grid $grid) {
            $lawyerID = $grid->model()->filter()->input('no') ?? ''; //律师ID
            $nowyear = date("Y");
            $year = $grid->model()->filter()->input('year') ?? date('Y');
            $monthNum = ($year && $year < $nowyear)  ? 12 : date('m');

            for ($i = 1; $i <= $monthNum; $i++) {
                $grid->column($i, $i . '月');
            }

            $grid->disableActions();
            $grid->disableViewButton();
            $grid->disableCreateButton();
            $grid->disableRowSelector();
            $grid->disablePagination();

            $grid->filter(function (Grid\Filter $filter) {
                // 更改为 panel 布局
                $filter->panel();
                $filter->like('year', '年份')->width(3)->default(date("Y"))->ignore();
            });

            //文字信息
            $grid->tools(function (Grid\Tools $tools) use ($grid, $lawyerID, $year) {
                //导出按钮
                // 获取筛选条件
                $param = [
                    'search'   => ['lawyer_id' => $lawyerID, 'year' => $year, 'rtype' => 2]
                ];
                // 导出
                $filename = '已开票汇总表';
                $tools->append(new ReceivedInvoicedExcel($param, $filename, '导出'));
                //文字展示
                $fullname = $number = '';
                if ($lawyerID) {
                    $obj = ModelsLawyer::find($lawyerID);
                    $fullname = $obj->name;
                    $number = $obj->number;
                }
                $card_info = "&nbsp;&nbsp;律师编号：{$number}&nbsp;&nbsp;&nbsp;律师姓名：{$fullname}";

                $tools->append($card_info);
            });

            // $grid->export()->disableExportAll();
            // $grid->export()->disableExportSelectedRow();
            // $grid->export()->rows(function ($rows) {
            //     return $rows;
            // });

        });


        // 使用Tab面板展示两个数据列表
        $tab = Tab::make()->add('已收款汇总表', $grid1)->add('已开票汇总表', $grid2);

        return $content->body($tab);
    }

    /**
     * 导出
     *
     * @param Request $request
     * @return \Symfony\Component\HttpFoundation\BinaryFileResponse
     */
    public function receivedInvoicedExport(Request $request)
    {
        $filename = $request->get('filename');

        $param = json_decode($request->get('param'));

        ob_end_clean();
        return Excel::download(new ReceivedInvoicedExport($param), $filename . '.xlsx');
    }
}
