<?php

namespace App\Admin\Controllers;

use App\Models\Lawyer as ModelLawyer;
use App\Models\LawyerCost as ModelLawyerCost;
use App\Models\CovenantReceivePayment as ModelCovenantReceivePayment;
use Dcat\Admin\Form;
use Dcat\Admin\Grid;
use Dcat\Admin\Show;
use Dcat\Admin\Http\Controllers\AdminController;
use Dcat\Admin\Admin;

class LawyerIncomeController extends AdminController
{
    /**
     * 律师创收信息
     * Make a grid builder.
     * @return Grid
     */
    protected function grid()
    {
        return Grid::make(new ModelLawyer(), function (Grid $grid) {
            //$grid->column('id')->sortable();
            $year = $grid->model()->filter()->input('year') ?? date('Y');
            $grid->column('number', '律师编号');
            $grid->column('name', '律师姓名');
            $grid->column('sex', '性别')->display(function ($val) {
                return $val == 1 ? '男' : '女';
            });
            $grid->column('identity_card', '身份证号');
            $grid->column('phone', '手机号');
            $grid->column('field1', '开票金额')->display(function () use ($year) {
                //开票金额
                $invoiced_money = ModelCovenantReceivePayment::where(['lawyer_id' =>  $this->id, 'rtype' => 2])
                    ->where('invoiced_at', 'like', $year . '%')
                    ->sum('invoiced_money');
                return $invoiced_money;
            });
            $grid->column('field2', '已收款')->display(function () use ($year) {
                //已收款
                $receipt_money = ModelCovenantReceivePayment::where(['lawyer_id' => $this->id, 'rtype' => 1])
                    ->where('received_at', 'like', $year . '%')
                    ->sum('received_amount');
                return $receipt_money;
            });
            $grid->column('field3', '已收款未开票')->display(function () use ($year) {
                //开票金额
                $invoiced_money = ModelCovenantReceivePayment::where(['lawyer_id' =>  $this->id, 'rtype' => 2])
                    ->where('invoiced_at', 'like', $year . '%')
                    ->sum('invoiced_money');
                //已收款
                $receipt_money = ModelCovenantReceivePayment::where(['lawyer_id' => $this->id, 'rtype' => 1])
                    ->where('received_at', 'like', $year . '%')
                    ->sum('received_amount');
                //已收款未开票
                $receipt_noinvoice = ($receipt_money - $invoiced_money) > 0 ? $receipt_money - $invoiced_money : '-';
                return $receipt_noinvoice;
            });
            $grid->column('field4', '已开票未收款')->display(function ($val) {
                $id = $this->id;
                $year = date('Y');
                $linkstr = '';
                //创收收款表
                if (Admin::user()->can('lawyer-covenant-income')) {
                    $linkstr .=  '<a href="/lawyer-covenant-income?no=' . $id . '" target="_blank">创收收款表</a>&nbsp;&nbsp;';
                }
                //已收款/已开票汇总
                if (Admin::user()->can('received-invoiced')) {
                    $linkstr .=  '<a href="/receive_payment?no=' . $id . '&year=' . $year . '" target="_blank">已收款/已开票汇总</a><br/>';
                }
                return $linkstr;
            });

            $grid->disableCreateButton();
            $grid->disableViewButton();
            $grid->disableEditButton();
            $grid->disableRowSelector();
            $grid->disableActions();

            $grid->filter(function (Grid\Filter $filter) {
                // 更改为 panel 布局
                $filter->panel();
                $filter->like('number', '律师编号')->width(3);
                $filter->like('name', '律师姓名')->width(3);
                $filter->like('year', '年份')->width(3)->default(date("Y"))->ignore();
                //$filter->date('sign_at')->format('YYYY-MM-DD');
            });
        });
    }

    /**
     * Make a show builder.
     *
     * @param mixed $id
     *
     * @return Show
     */
    protected function detail($id)
    {
        return Show::make($id, new ModelLawyerCost(), function (Show $show) {
            $show->field('id');
            $show->field('year');
            $show->field('month');
            $show->field('number');
            $show->field('lname');
            $show->field('basic_salary');
            $show->field('social_person_fee');
            $show->field('social_company_fee');
            $show->field('accumulation_fund_person_fee');
            $show->field('accumulation_fund_company_fee');
            $show->field('annual_inspection_fee');
            $show->field('annuity');
            $show->field('office_rental_fee');
            $show->field('noticket_cost');
            $show->field('posting_tickets_fee');
            $show->field('assistant_fee');
            $show->field('special_additional');
            $show->field('advance_fee');
            $show->field('personal_income_tax');
            $show->field('created_at');
            $show->field('updated_at');
        });
    }

    /**
     * Make a form builder.
     *
     * @return Form
     */
    protected function form()
    {
        return Form::make(new ModelLawyerCost(), function (Form $form) {
            $form->display('id');
            $form->text('year');
            $form->select('month')->options(ModelLawyerCost::MONTH);
            $form->text('number');
            $form->text('lname');
            $form->text('basic_salary');
            $form->text('social_person_fee');
            $form->text('social_company_fee');
            //$form->display('social', '社保')->default(100);
            $form->text('accumulation_fund_person_fee');
            $form->text('accumulation_fund_company_fee');
            $form->text('annual_inspection_fee');
            $form->text('annuity');
            $form->text('office_rental_fee');
            //$form->text('noticket_cost');
            //$form->text('posting_tickets_fee');
            $form->text('assistant_fee');
            $form->text('special_additional');
            $form->text('advance_fee');
            $form->text('personal_income_tax');

            $form->disableCreatingCheck();
            $form->disableEditingCheck();
            $form->disableViewCheck();
            $form->disableDeleteButton();
            $form->disableViewButton();

            $form->display('created_at');
            $form->display('updated_at');
        });
    }
}
