<?php

namespace App\Admin\Controllers;

use App\Models\LawyerCost as ModelLawyerCost;
use App\Admin\Repositories\Lawyer;
use App\Models\Lawyer as ModelsLawyer;
use Dcat\Admin\Form;
use Dcat\Admin\Grid;
use Dcat\Admin\Show;
use Dcat\Admin\Http\Controllers\AdminController;
use Illuminate\Support\Facades\DB;
use Dcat\Admin\Admin;

class LawyerCostListController extends AdminController
{
    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
        return Grid::make(new ModelLawyerCost(), function (Grid $grid) {
            $number = $grid->model()->filter()->input('no') ?? ''; //律师编号
            $year = $grid->model()->filter()->input('year') ?? '';
            $where = [];
            if ($number) {
                $where['number'] = $number;
            }
            if ($year) {
                $where['year'] = $year;
            }
            $grid->model()->where($where);
            //$grid->column('id')->sortable();
            $grid->column('year', '年份');
            $grid->column('month', '月份');
            $grid->column('basic_salary', '基本工资');
            $grid->column('special_additional', '专项附加');
            $grid->column('social', '社保')->display(function ($val) {
                $total = $this->social_person_fee + $this->social_company_fee;
                return sprintf("%.2f", $total);
            });
            $grid->column('social_person_fee', '社保个人部分');
            $grid->column('social_company_fee', '社保公司部分');
            $grid->column('accumulation_fund', '公积金')->display(function ($val) {
                $total = $this->accumulation_fund_person_fee + $this->accumulation_fund_company_fee;
                return sprintf("%.2f", $total);
            });
            $grid->column('accumulation_fund_person_fee', '公积金个人部分');
            $grid->column('accumulation_fund_company_fee', '公积金公司部分');
            $grid->column('annual_inspection_fee', '律所年检费');
            $grid->column('annuity', '律所年金');
            $grid->column('posting_tickets_fee', '贴票成本')->display(function () {
                return $this->assistant_fee;
            });
            $grid->column('assistant_fee', '助理律师成本');
            $grid->column('office_rental_fee', '办公租赁成本');
            $grid->column('noticket_cost', '无票成本');
            $grid->column('personal_income_tax', '个人所得税');
            $grid->column('advance_fee', '预支款');

            $grid->disableViewButton();
            $grid->disableCreateButton();
            $grid->disableRowSelector();
            if (!Admin::user()->can('lawyer_cost_list_edit')) {
                $grid->disableEditButton();
            }
            if (!Admin::user()->can('lawyer_cost_list_delete')) {
                $grid->disableEditButton();
            }

            $grid->filter(function (Grid\Filter $filter) {
                // 更改为 panel 布局
                $filter->panel();
                $filter->like('year', '年份')->width(3)->default(date("Y"));
            });

            //文字信息
            $grid->tools(function (Grid\Tools $tools) use ($grid, $number) {
                $fullname = '';
                if ($number) {
                    $obj = ModelsLawyer::where('number', $number)->first();
                    $fullname = $obj->name;
                }
                $card_info = "&nbsp;&nbsp;律师编号：{$number}&nbsp;&nbsp;&nbsp;律师姓名：{$fullname}";

                $tools->append($card_info);
            });
        });
    }

    /**
     * Make a show builder.
     *
     * @param mixed $id
     *
     * @return Show
     */
    protected function detail($id)
    {
        return Show::make($id, new ModelLawyerCost(), function (Show $show) {
            $show->field('id');
            $show->field('year');
            $show->field('month');
            $show->field('number');
            $show->field('lname');
            $show->field('basic_salary');
            $show->field('social_person_fee');
            $show->field('social_company_fee');
            $show->field('accumulation_fund_person_fee');
            $show->field('accumulation_fund_company_fee');
            $show->field('annual_inspection_fee');
            $show->field('annuity');
            $show->field('office_rental_fee');
            $show->field('noticket_cost');
            $show->field('posting_tickets_fee');
            $show->field('assistant_fee');
            $show->field('special_additional');
            $show->field('advance_fee');
            $show->field('personal_income_tax');
            $show->field('created_at');
            $show->field('updated_at');
        });
    }

    /**
     * Make a form builder.
     *
     * @return Form
     */
    protected function form()
    {
        $form = Form::make(new ModelLawyerCost(), function (Form $form) {
            $form->display('id');
            $form->text('year')->required();
            $form->select('month')->options(ModelLawyerCost::MONTH);
            $form->display('number');
            $form->text('lname')->required();
            $form->text('basic_salary')->required();
            $form->text('social_person_fee')->required();
            $form->text('social_company_fee')->required();
            //$social = $form->model()->social;
            $form->text('social', '社保')->readOnly();
            $form->text('accumulation_fund_person_fee')->required();
            $form->text('accumulation_fund_company_fee')->required();
            $form->text('accumulation_fund', '公积金')->readOnly();
            $form->text('annual_inspection_fee')->required();
            $form->text('annuity')->required();
            $form->text('office_rental_fee')->required();
            $form->text('noticket_cost')->readOnly();
            //$form->text('posting_tickets_fee');
            $form->text('assistant_fee')->required();
            $form->text('special_additional')->required();
            $form->text('advance_fee');
            $form->text('personal_income_tax')->required();

            $form->disableCreatingCheck();
            $form->disableEditingCheck();
            $form->disableViewCheck();
            $form->disableDeleteButton();
            $form->disableViewButton();

            // $form->display('created_at');
            // $form->display('updated_at');
        });

        Admin::script(
            <<<JS
            $(function () {
                //社保
                $("input[name='social_company_fee']").on('blur', function() {
                    var person_fee = $("input[name='social_person_fee']").val().length>0?$("input[name='social_person_fee']").val():0;
                    var company_fee = $("input[name='social_company_fee']").val().length>0?$("input[name='social_company_fee']").val():0;
                    var total = parseFloat(person_fee) + parseFloat(company_fee);
                    $("input[name='social']").val(total);
                });
                //公积金
                $("input[name='accumulation_fund_company_fee']").on('blur', function() {
                    var person_fee = $("input[name='accumulation_fund_person_fee']").val().length>0?$("input[name='accumulation_fund_person_fee']").val():0;
                    var company_fee = $("input[name='accumulation_fund_company_fee']").val().length>0?$("input[name='accumulation_fund_company_fee']").val():0;
                    var accumulation_fund = parseFloat(person_fee) + parseFloat(company_fee);
                    $("input[name='accumulation_fund']").val(accumulation_fund);
                });
                //无票成本
                $("input[name='office_rental_fee']").on('blur', function() {
                    //基本工资
                    var salary = $("input[name='basic_salary']").val().length>0?$("input[name='basic_salary']").val():0;
                    //专项附加
                    var additional = $("input[name='special_additional']").val().length>0?$("input[name='special_additional']").val():0;
                    //社保单位部分
                    var social_company = $("input[name='social_company_fee']").val().lenght>0?$("input[name='social_company_fee']").val():0;
                    //公积金单位部分
                    var accumulation_fund = $("input[name='accumulation_fund_company_fee']").val().length>0?$("input[name='accumulation_fund_company_fee']").val():0;
                    //助理律师成本
                    var assistant_fee = $("input[name='assistant_fee']").val().length>0?$("input[name='assistant_fee']").val():0;
                    //办公室租赁成本
                    var office_rental_fee = $("input[name='office_rental_fee']").val().length>0?$("input[name='office_rental_fee']").val():0;

                    var cost = parseFloat(salary) + parseFloat(additional)+ parseFloat(social_company)+ parseFloat(accumulation_fund)+ parseFloat(assistant_fee)+ parseFloat(office_rental_fee);
                    $("input[name='noticket_cost']").val(cost);
                });
            });
            JS
        );

        //副表保存规格
        $form->saved(
            function (Form $form, $result) {
                $cost_id = $form->getKey();

                $basic_salary = $_POST['basic_salary'] ?? 0;
                $special_additional = $_POST['special_additional'] ?? 0;
                $social_company_fee = $_POST['social_company_fee'] ?? 0;
                $accumulation_fund_company_fee = $_POST['accumulation_fund_company_fee'] ?? 0;
                $assistant_fee = $_POST['assistant_fee'] ?? 0;
                $office_rental_fee = $_POST['office_rental_fee'] ?? 0;
                //无票成本
                $noticket_cost = floatval($basic_salary) + floatval($special_additional) + floatval($social_company_fee) + floatval($accumulation_fund_company_fee) + floatval($assistant_fee) + floatval($office_rental_fee);
                //社保
                $social_person_fee = $_POST['social_person_fee'] ?? 0;
                $social = floatval($social_person_fee) + floatval($social_company_fee);
                //公积金
                $accumulation_fund_person_fee = $_POST['accumulation_fund_person_fee'] ?? 0;
                $accumulation_fund = floatval($accumulation_fund_person_fee) + floatval($accumulation_fund_company_fee);
                if ($result) {
                    DB::table('lawyer_cost')->where("id", $cost_id)->update(['social' => $social, 'accumulation_fund' => $accumulation_fund, 'noticket_cost' => $noticket_cost]);
                }
            }
        );

        return $form;
    }
}
