<?php

namespace App\Admin\Controllers;

use App\Admin\Repositories\LawyerCollect;
use App\Models\Covenant as ModelsCovenant;
use App\Models\CovenantReceivePayment as ModelsCovenantReceivePayment;
use App\Models\Lawyer as ModelLawyer;
use App\Models\LawyerCost as ModelLawyerCost;
use Dcat\Admin\Form;
use Dcat\Admin\Grid;
use Dcat\Admin\Show;
use Dcat\Admin\Http\Controllers\AdminController;
use App\Admin\Actions\CovenantReceive;
use App\Admin\Actions\CovenantInvoice;
use Dcat\Admin\Admin;

class LawyerCollectController extends AdminController
{
    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
        return Grid::make(new LawyerCollect(), function (Grid $grid) {
            //筛选参数
            $received_at = $invoiced_at = $params = [];
            $params['number'] = $_GET['number'] ?? ''; //律师编号
            $params['year'] = $_GET['number'] ?? date('Y'); //律师编号
            $received_at['start'] = isset($_GET['received_at']['start']) && $_GET['received_at']['start'] ? $_GET['received_at']['start'] . "-01" : '';
            $received_at['end'] = isset($_GET['received_at']['end']) && $_GET['received_at']['end'] ? $_GET['received_at']['end'] . "-31" : '';
            $invoiced_at['start'] = isset($_GET['invoiced_at']['start']) && $_GET['invoiced_at']['start']  ? $_GET['invoiced_at']['start'] . '-01' : '';
            $invoiced_at['end'] = isset($_GET['invoiced_at']['end']) && $_GET['invoiced_at']['end'] ? $_GET['invoiced_at']['end'] . '-31' : '';

            $lawyer_id = 0;
            $number = $params['number'];
            $year = $params['year'];
            $lawyObj = ModelLawyer::where('number', $number)->first();
            if ($lawyObj) {
                $lawyer_id = $lawyObj->number;
            }

            $totalInfo = ModelLawyer::getTotalInfo($params, $received_at, $invoiced_at);
            //创收已收款
            $received_amount = $totalInfo['receipt_money']; //ModelsCovenantReceivePayment::getReceivedMoneyByNumber($number, $year, $received_at, $invoiced_at);
            //已开票
            $invoiced_money = $totalInfo['invoiced_money']; //ModelsCovenantReceivePayment::getInvoicedMoneyByNumber($number, $year, $received_at, $invoiced_at);
            //收款未开票
            $received_noinvoiced = ($received_amount - $invoiced_money) > 0 ? $received_amount - $invoiced_money : 0;
            //开票未收款
            $invoiced_noreceived = ($invoiced_money - $received_amount) > 0 ? $invoiced_money - $received_amount : 0;
            //提成金额
            $commissionAmount = $totalInfo['commission_amount']; //ModelsCovenantReceivePayment::getCommissionAmount($number, $year, $received_at);
            //成本合计
            $costTotal = $totalInfo['cost'];
            //基本工资
            $basicSalary = $totalInfo['salary'];
            //专项附加
            $special_additional = $totalInfo['special_additional'];
            //社保 
            $social = $totalInfo['social'];
            //公积金
            $accumulation_fund = $totalInfo['accumulation_fund'];
            //贴票金额
            $posting_tickets = $totalInfo['tickets_money'];
            //预支款
            $advance_fee = $totalInfo['advance_fee'];
            //可结算提成
            $payable_amount = $totalInfo['payable_commission'];
            // 添加一行表头数据
            $grid->header(function () use ($received_amount, $commissionAmount, $received_noinvoiced, $invoiced_noreceived, $costTotal, $basicSalary, $special_additional, $social, $accumulation_fund, $posting_tickets, $advance_fee, $payable_amount) {
                return '<div class="table-responsive table-wrapper complex-container table-middle mt-1 table-collapse ">
        <table class="table custom-data-table data-table" border=1 id="grid-table">
            <thead>
                        <tr>
                                    <th width="90">&nbsp;&nbsp;&nbsp;</th>
                                    <th width="90">&nbsp;&nbsp;合计&nbsp;&nbsp;</th>
                                    <th width="90">&nbsp;&nbsp;</th>
                                    <th width="90" style="text-align:center;">' . $received_amount . '</th>
                                    <th width="80" style="text-align:center;">' . $commissionAmount . '</th>
                                    <th width="90" style="text-align:center;">' . $received_noinvoiced . '</th>
                                    <th width="90" style="text-align:center;">' . $invoiced_noreceived . '</th>
                                    <th width="90" style="text-align:center;">' . $costTotal . '</th>
                                    <th width="90" style="text-align:center;">' . $basicSalary . '</th>
                                    <th width="90" style="text-align:center;">' . $special_additional . '</th>
                                    <th width="90" style="text-align:center;">' . $social . '</th>
                                    <th width="90" style="text-align:center;">' . $accumulation_fund . '</th>
                                    <th width="90" style="text-align:center;">' . $posting_tickets . '</th>
                                    <th width="90" style="text-align:center;">' . $advance_fee . '</th>
                                    <th width="90" style="text-align:center;">' . $payable_amount . '</th>
                            </tr>
            </thead>

            
            <tbody>
                                    </tbody>
        </table>
    </div>';
            });
            // $grid->header(function () {
            //     return '<div class="row" style="text-align:center;">' .
            //         '<div class="col-md-3" >合计</div>' .
            //         '<div class="col-md-1">1</div>' .
            //         '<div class="col-md-1">2</div>' .
            //         '<div class="col-md-1">3</div>' .
            //         '<div class="col-md-1">4</div>' .
            //         '<div class="col-md-1">5</div>' .
            //         '<div class="col-md-1">6</div>' .
            //         '<div class="col-md-1">7</div>' .
            //         '<div class="col-md-1">8</div>' .
            //         '<div class="col-md-1">9</div>' .
            //         '<div class="col-md-1">10</div>' .
            //         '<div class="col-md-1">11</div>' .
            //         '</div>';
            // });
            //$grid->column('id')->sortable();
            $grid->column('lnumber', '律师编号')->width(90);
            $grid->column('lname', '律师名称')->width(90);
            $grid->column('commission_ratio', '提成比例(%)')->width(90);
            $grid->column('receipt_money', '创收已收款')->width(90);
            $grid->column('commission_amount', '提成金额')->width(80);
            $grid->column('receipt_noinvoice', '已收款未开票')->width(90);
            $grid->column('invoice_noreceipt', '已开票未收款')->width(90);
            $grid->column('cost', '成本合计')->width(90);
            $grid->column('basic_salary', '基本工资')->width(90);
            $grid->column('special_additional', '专项附加')->width(90);
            $grid->column('social', '社保')->width(90);
            $grid->column('accumulation_fund', '公积金')->width(90);
            $grid->column('posting_tickets_fee', '贴票金额')->width(90);
            $grid->column('advance_fee', '预支款')->width(90);
            $grid->column('payable_commission', '可结算提成')->width(90);

            // $grid->column('created_at');
            // $grid->column('updated_at')->sortable();

            $grid->disableCreateButton();
            $grid->disableViewButton();
            $grid->disableRowSelector();
            $grid->disableActions();

            $grid->filter(function (Grid\Filter $filter) {
                // 更改为 panel 布局
                $filter->panel();
                $filter->like('number', '律师编号')->width(3);
                $filter->like('name', '律师姓名')->width(3);
                $filter->equal('year', '年份')->width(3)->default(date('Y'));
                $filter->between('received_at', '收款日期')->month()->width(4);
                $filter->between('invoiced_at', '开票日期')->month()->width(4);
            });

            $grid->actions(function (Grid\Displayers\Actions $actions) {
                //编辑
                if (!Admin::user()->can('lawyer_cost_list_edit')) {
                    $actions->disableEdit();
                }
                //删除
                if (!Admin::user()->can('lawyer_cost_list_edit-delete')) {
                    $actions->disableDelete();
                }
            });
        });
    }
}
