<?php

namespace App\Admin\Controllers;

use App\Models\CovenantReceivePayment as ModelsCovenantReceivePayment;
use App\Models\Covenant as ModelsCovenant;
use Dcat\Admin\Form;
use Dcat\Admin\Grid;
use Dcat\Admin\Show;
use Dcat\Admin\Http\Controllers\AdminController;
use App\Admin\Repositories\CovenantReceivePaymentCollect;
use Carbon\Carbon;
use Dcat\Admin\Support\Helper;

class CovenantReceivePaymentController extends AdminController
{
    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
        return Grid::make(new CovenantReceivePaymentCollect(), function (Grid $grid) {
            // 获取筛选条件
            $params = [];
            $params['lnum'] = $_GET['lnum'] ?? '';
            $params['lname'] = $_GET['lname'] ?? '';
            $params['cnum'] = $_GET['cnum'] ?? '';
            $params['ctype'] = $_GET['ctype'] ?? '';
            $params['principal'] = $_GET['principal'] ?? '';
            $received_at = $invoiced_at = [];
            $received_at['start'] = $_GET['received_at']['start'] ?? '';
            $received_at['end'] = $_GET['received_at']['end'] ?? '';
            $invoiced_at['start'] = $_GET['invoiced_at']['start'] ?? '';
            $invoiced_at['end'] = $_GET['invoiced_at']['end'] ?? '';
            //已收款
            $receivedMoney = ModelsCovenantReceivePayment::getTotalReceivedAmount($params, $received_at, $invoiced_at);
            //开票金额
            $invoicedMoney = ModelsCovenantReceivePayment::getTotalInvoicedMoney($params, $received_at, $invoiced_at);
            //已收款未开票
            $receiptNoinvoice = ($receivedMoney - $invoicedMoney) > 0 ? $receivedMoney - $invoicedMoney : 0;
            //已开票未收款
            $invoiceNoreceipt = ($invoicedMoney - $receivedMoney) > 0 ? $invoicedMoney - $receivedMoney : 0;
            // 添加一行表头数据
            // $grid->header(function () use ($invoicedMoney, $receivedMoney, $receiptNoinvoice, $invoiceNoreceipt) {
            //     return '<div class="row" style="text-align:center;">' .
            //         '<div class="col-md-7" >合计</div>' .
            //         '<div class="col-md-1">' . $invoicedMoney . '</div>' .
            //         '<div class="col-md-1">' . $receivedMoney . '</div>' .
            //         '<div class="col-md-1">' . $receiptNoinvoice . '</div>' .
            //         '<div class="col-md-2">' . $invoiceNoreceipt . '</div>' .
            //         '</div>';
            // });
            $grid->header(function () use ($invoicedMoney, $receivedMoney, $receiptNoinvoice, $invoiceNoreceipt) {
                return '<div class="table-responsive table-wrapper complex-container table-middle mt-1 table-collapse ">
        <table class="table custom-data-table data-table" id="grid-table" border=0>
            <thead>
                        <tr>
                                    <th width="90"></th>
                                    <th width="90"></th>
                                    <th width="90"></th>
                                    <th width="90">合计</th>
                                    <th width="90"></th>
                                    <th width="90"></th>
                                    <th width="90" text-align="center"> ' . $invoicedMoney . '</th>
                                    <th width="90"> ' . $receivedMoney . '</th>
                                    <th width="90"> ' . $receiptNoinvoice . '</th>
                                    <th width="90"> ' . $invoiceNoreceipt . '</th>
                            </tr>
            </thead>

            
            <tbody>
                                    </tbody>
        </table>
    </div>';
            });
            //$grid->column('id')->sortable();
            $grid->column('lnum', '律师编号')->width(90);
            $grid->column('lname', '律师姓名')->width(90);
            $grid->column('covenant_num', '合同编号')->width(90);
            $grid->column('covenant_name', '合同名称')->width(90);
            $grid->column('covenant_type', '合同类型')->width(90);
            $grid->column('principal', '委托人')->width(90);
            $grid->column('invoice_amount', '开票金额')->width(90);
            $grid->column('receipt_money', '已收款')->width(90);
            $grid->column('receipt_noinvoice', '已收款未开票')->width(90);
            $grid->column('invoice_noreceipt', '已开票未收款')->width(90);
            //$grid->column('updated_at')->sortable();

            $grid->disableCreateButton();
            $grid->disableRowSelector();
            $grid->disableActions();

            $grid->filter(function (Grid\Filter $filter) {
                // 更改为 panel 布局
                $filter->panel();
                $filter->like('lnum', '律师编号')->width(3);
                $filter->like('lname', '律师名称')->width(3);
                $filter->like('cnum', '合同编号')->width(3);
                $filter->equal('ctype', '合同类型')->select(ModelsCovenant::CTYPE)->width(3);
                $filter->like('principal', '委托人')->width(3);
                $filter->between('received_at', '收款日期')->date()->width(4);
                $filter->between('invoiced_at', '开票日期')->date()->width(4);
            });
        });
    }
}
