//通用公共方法
import request from './request.js'
export default {
	//跳转到商品详情
	goProductDetails(id) {
		console.log(1)
		uni.navigateTo({
			url: '/pageSub-product/pages/productDetails/productDetails?id=' + id
		})
	},
	payOrder(id, payType) {
		let _this = this;
		request('/pay', 'POST', {
			order_id: id,
			pay_type: payType
		}).then(res => {
			if (payType == 2) {
				uni.showToast({
					title: '支付成功！',
					icon: 'success'
				});
				console.log('用户支付扣款成功', res)
				_this.goMyOrderlist('-1');
				return
			}
			//调用微信官方支付接口弹出付款界面,输入密码扣款
			wx.requestPayment({
				appid: res.data.appId,
				timeStamp: res.data.timestamp, //后端返回的时间戳
				nonceStr: res.data.nonceStr, //后端返回的随机字符串
				package: res.data.package, //后端返回的prepay_id
				signType: res.data.signType, //后端签名算法,根据后端来,后端MD5这里即为MD5
				paySign: res.data.paySign, //后端返回的签名
				success(res) {
					uni.showToast({
						title: '支付成功！',
						icon: 'success'
					});
					console.log('用户支付扣款成功', res)
					_this.goMyOrderlist('-1');
				},
				fail(res) {
					uni.showToast({
						title: '支付失败!',
						icon: 'error'
					});
					console.log('用户支付扣款失败', res)
					_this.goMyOrderlist('-1');
				}
			})
		}).catch(err => {
			console.log(err)
			uni.showToast({
				title: '' + err.message,
				icon: 'none'
			});
		})
	},
	user_share(code) {
		request('/user-share', 'GET', {
			spuid: code
		}).then(res => {
			uni.removeStorageSync('inviteCode');
		}).catch(err => {
			uni.showToast({
				title: '' + err.message,
				icon: 'error'
			});
		})
	},
	goMyOrderlist(e) {
		uni.redirectTo({
			url: '/pageSub-pc/pages/myOrderlist/myOrderlist?status=' + e,
			complete() {
				uni.removeStorageSync('address');
				uni.removeStorageSync('confirOrderObj');
				uni.removeStorageSync('getGoodsWayIndex');
			}
		})
	},
	async fungoPreviousPage() {
		uni.showToast({
			title: "请先登录！"
		});
		let routes = getCurrentPages(); // 获取当前打开过的页面路由数组
		let curRoute = routes[routes.length - 1].route //获取当前页面路由
		let curParam = routes[routes.length - 1].options; //获取路由参数
		console.log(curRoute, curParam)
		// 拼接参数
		let param = ''
		for (let key in curParam) {
			if (!param) {
				param += key + '=' + curParam[key]
			} else {
				param += '&' + key + '=' + curParam[key]
			}
		}
		await uni.setStorageSync('pageUrl', param ? `/${curRoute}?${param}` : `/${curRoute}`);
		uni.reLaunch({
			url: '/pages/login/login'
		})
	},
	amend(num1, num2, symbol) {
		var str1 = num1.toString(),
			str2 = num2.toString(),
			result, str1Length, str2Length
		//解决整数没有小数点方法
		try {
			str1Length = str1.split('.')[1].length
		} catch (error) {
			str1Length = 0
		}
		try {
			str2Length = str2.split('.')[1].length
		} catch (error) {
			str2Length = 0
		}
		var step = Math.pow(10, Math.max(str1Length, str2Length))
		// 
		console.log(step);
		switch (symbol) {
			case "+":
				result = (num1 * step + num2 * step) / step
				break;
			case "-":
				result = (num1 * step - num2 * step) / step
				break;
			case "*":
				result = ((num1 * step) * (num2 * step)) / step / step
				break;
			case "/":
				result = (num1 * step) / (num2 * step)
				break;
			default:
				break;
		}
		return result

	},

	isTimeMoreThanOneDayFromNow(dateString) {
		const now = new Date();
		const oneDayLater = new Date(now.setDate(now.getDate() + 1));
		const targetDate = new Date(dateString);

		return targetDate > oneDayLater;
	}
}