import commmon from './common.js';

const request = (url = '', method = 'GET', data = {}, header = { //这里这样封装是为了后续具体组件中使用时可以直接传参,需按此顺序传参；而不需要写url：xxx等键值对传参
	//具体的header和后端商同后再编写，这里以常见的token为例
	'Authorization': uni.getStorageSync('token') ? uni.getStorageSync('token') : '',
}) => {
	return new Promise((resolve, reject) => {
		uni.request({
			url: commmon.BASE_URL + url, //接口地址：前缀+方法中传入的地址
			method: method.toUpperCase(), //请求方法
			data: data, //传递参数
			header: header, //自定义头部，和后端商同后编写
			success: (res) => {
				console.log(res)
				if (res.data.code == 403) { //自定请求失败的情况，这里以常见的token失效或过期为例
					uni.removeStorageSync('token');
					uni.reLaunch({
						url: '/pages/login/login'
					})
					return
				}
				if (res.data.code == 500 || res.data.code == 201) { //自定请求失败的情况
					reject(res.data)
					return
				}
				if (res.data.code == 200) {
					resolve(res.data)
					return
				}
			},
			fail: (err) => {
				reject(err)
			}
		})
	})
}

export default request;