<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

//Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
//    return $request->user();
//});


Route::namespace('App\Http\Controllers\Api')->middleware('acceptJson')->group(function () {

    //轮训接口
    Route::get('updateOrderStatusToDiv','OrderDivideRecordController@updateOrderStatusToDiv');  //分佣订单解冻轮训
    Route::get('pointUnfreezeEnd','OrderDivideRecordController@pointUnfreezeEnd');  //订单积分解冻轮训

    //调试路由
    Route::post('simulate-login','LoginController@simulateLogin');  //模拟登陆
    Route::get('test1','StoreController@testHaversineDistance');  //测试内容-什么都测
    Route::get('test-order-div','CarouselController@orderDiv');  //测试订单分佣
    Route::get('test-order-div-point','CarouselController@orderDivByPoint');  //测试订单积分生成

    Route::post('manual-divide','OrderDivideRecordController@manualDivide');  //手动分账【开发手动调接口修正数据】

    Route::get('refreshTokenLYK', 'OrderController@refreshTokenLYK');  //手动刷新token

    Route::post('get-openid', 'LoginController@getOpenid');  //获取openid

    Route::post('login', 'LoginController@login')->name('login');  //用户端授权登录

    Route::get('test-login', 'LoginController@testLogin');  //测试登录

    Route::get('city-code', 'BaseController@addCityCode');  //导入城市编码(汇付)

    Route::post('hf-company-member-notify', 'HfCompanyMemberController@notify');  //汇付 创建企业用户异步通知

    Route::get('hf-bank-code', 'HfSettleAccountController@getBankCode');  //汇付 银行代码

    Route::get('hf-provarea-code', 'HfProvAreaCodeController@getList');  //汇付 省市编码

    Route::get('hf-query-list', 'HfOrderController@autoQueryList');  //汇付 定时查询支付对象列表

    Route::post('hf-payment-confirm', 'HfOrderController@paymentConfirm');  //汇付 手动创建支付确认

    //Route::post('mobile-login', 'LoginController@mobilelogin');  //验证码登录

    Route::post('account-login', 'StoreAdminUsersController@login');  //账号密码登录

    Route::post('reset', 'LoginController@reset');  //重新提交

    //Route::post('send-sms-code', 'LoginController@sendCode');  //发送短信

    Route::post('update-pwd', 'UserController@updatePwd');  //修改密码

    Route::get('carousel', 'CarouselController@getList');  //轮播列表

    Route::get('comment-tpl', 'CommentTplController@getList');  //评价模板

    Route::get('get-cate-list', 'CategoryController@getList');  //一级分类列表

    Route::get('article-list', 'ArticleController@getList');  //文章列表

    Route::get('article-detail', 'ArticleController@getDetail');  //文章详情
    // Route::get('get-seccate-list', 'CategoryController@getSecList');  //二级分类列表

    // Route::get('get-third-list', 'CategoryController@getThirdList');  //三级分类列表

    Route::get('goods-list', 'GoodController@getList');  //分类商品列表

    Route::get('recommend-good', 'GoodController@getIndexGoods');  //首页商品列表

    Route::post('get-ajax-attr', 'GoodController@getAttrKey');  //商品规格查询

    Route::get('get-kefu-list', 'KefuController@getList');  //客服列表

    Route::get('company-intro', 'SystemSettingController@companyIntro');  //公司介绍

    Route::get('cashout-intro', 'SystemSettingController@cashoutIntro');  //提现须知

    Route::post('upload-file', 'UserController@uploadFile');  //统一上传接口

    Route::get('get-invite-bj', 'SystemSettingController@getBj');  //邀请背景

    Route::get('get-good-detail', 'GoodController@getDetail');  //商品详情

    Route::get('comment-list', 'CommentController@getList');  //评价列表

    Route::any('pay-notify', 'OrderController@payNotify');  //付款回调

    Route::any('refund-notify', 'HfOrderController@refundNotify');  //退款回调

    Route::get('send/config/update', 'SystemController@update');

    Route::get('auto-to-commentstatus', 'SystemController@autoChangeReceiveStatus');  //定时任务--待领取状态下七天未领取，自动到待评价状态

    Route::get('auto-order-commission', 'SystemController@autoOrderCommission'); //定时完成--订单完成后分佣

    Route::middleware('auth:sanctum')->group(function () {

        Route::get('user-info', 'UserController@info');  //获取小程序端用户资料

        Route::get('get-user-point-list', 'UserController@getUserPointList');  //获取小程序端用户资料

        Route::get('get-employee-user-list', 'StoreAdminUsersController@getEmployeeUserList');  //查询员工绑定用户列表

        Route::get('merchant-info', 'StoreAdminUsersController@info');  //获取商户端用户资料

        Route::post('merchant-login', 'LoginController@merchantLogin');  //商户端授权登录

        Route::get('logout', 'LoginController@logout');  //登出

        Route::get('home', 'UserController@home');  //首页数据

        Route::get('recommend-good-auth', 'GoodController@getIndexGoods');  //首页商品列表

        Route::get('goods-list-auth', 'GoodController@getList');  //分类商品列表

        Route::get('get-good-detail-auth', 'GoodController@getDetail');  //商品详情

        Route::post('get-ajax-attr-auth', 'GoodController@getAttrKey');  //商品规格查询

        Route::post('upload', 'UserController@uploadFile');  //统一上传接口

        Route::get('qrCode', 'SystemSettingController@qrCode');  //生成二维码

        Route::post('verification-qrCode', 'SystemSettingController@verificationGrCode');  //核销码二维码

        Route::post('edit-user', 'UserController@editUser');  //修改用户资料

        Route::get('user-share', 'UserController@share');  //用户二维码分享

        Route::get('my-friend', 'UserController@getMyFriend');  //我的好友

        Route::post('bind-buycode', 'UserController@bindBuycode');  //绑定直购码

        Route::post('add-shopping-cart', 'UserController@addShoppingCart');  //添加购物车

        Route::get('show-shopping-cart', 'UserController@showShoppingCart');  //购物车详情

        Route::post('reduce-shopping-cart', 'UserController@reduceShoppingCart');  //删减购物车

        Route::post('number-shopping-cart', 'UserController@numberShoppingCart');  //购物车商品加减

        Route::post('express-collection', 'StoreController@getDeliveryList');  //快递代收点

        Route::post('check-distance', 'StoreController@checkDistance');  //送货上门-距离判断

        Route::post('create-buy-order', 'OrderController@CreateBuyOrder');  //创建订单--立即购买

        Route::post('checkout-buy-order', 'OrderController@CheckoutBuyOrder');  //立即购买-确认订单

        Route::post('checkout-cart-order', 'OrderController@CheckoutCartOrder');  //购物车-确认订单

        Route::post('create-order', 'OrderController@CreateOrder');  //创建订单

        Route::get('order-info', 'OrderController@OrderInfo');  //订单详情

        Route::get('del-order', 'OrderController@delOrder');  //删除订单

        Route::get('order-list', 'OrderController@orderList');  //订单列表

        Route::post('cance-order', 'OrderController@canceOrder');  //取消订单

        Route::post('pay', 'OrderController@pay');  //统一支付

        Route::get('address-list', 'UserController@getUserAddress');  //获取收货地址列表

        Route::post('set-address', 'UserController@setUserAddress');  //设置收货地址

        Route::post('del-address', 'UserController@delUserAddress');  //删除收货地址

        Route::get('goods-collect', 'UserCollectController@collectOpt');  //商品收藏/取消收藏

        Route::get('get-collect-list', 'UserCollectController@collectList');  //收藏列表

        Route::get('is-collect', 'GoodController@isCollect');  //查询商品是否收藏

        Route::post('upload-img', 'UserController@uploadImg');  //图片统一上传接口

        Route::post('edit-user', 'UserController@editUser');  //更新用户

        Route::post('add-comment', 'CommentController@add');  //去评价

        /*------------------------------商户端------------------------------------*/

        Route::get('commission-list', 'OrderDivideRecordController@getList');  //直推、间推明细--【商户、员工分佣明细】

        Route::get('income-list', 'IncomeController@getList');  //用户提现明细

        Route::post('income-add', 'IncomeController@add');  //去提现

        Route::get('my-member', 'MerchantController@getUserList');  //商户端-我的用户

        Route::post('my-member-orderlist', 'MerchantController@getOrderList');  //商户端-我的用户(查看订单)

        Route::post('scan-code-detail', 'OrderController@scanCodeDetail');  //扫码核销展示详情

        Route::post('scan-code-verifi', 'OrderController@scanCodeVerifi');  //扫码核销确认

        Route::get('merchant-order-collect', 'OrderController@orderCollect');  //商户端首页统计

        /*------------------------------汇付天下------------------------------------*/
        Route::post('hf-settle-account-delete', 'HfSettleAccountController@deleteAccount');  //汇付 删除结算账户

        Route::post('hf-settle-account-member', 'HfSettleAccountController@createMemberAccount');  //汇付 创建普通用户结算账户

        Route::post('hf-settle-account-company', 'HfSettleAccountController@createCompanyAccount');  //汇付 创建企业用户结算账户

        Route::get('hf-mycard', 'HfSettleAccountController@myCard');  //查询已绑定结算账户

        Route::post('hf-settle-account-query', 'HfSettleAccountController@queryAccount');  //汇付 查询用户结算账户

        Route::get('hf-account-balance', 'HfSettleAccountController@queryBalance');  //汇付 查询账户余额

    });
});
