<div {!! $attributes !!}>
    <div class="card-header d-flex justify-content-between align-items-start pb-0">
        <div>
            @if($icon)
            <div class="avatar bg-rgba-{{ $style }} p-50 m-0">
                <div class="avatar-content">
                    <i class="{{ $icon }} text-{{ $style }} font-medium-5"></i>
                </div>
            </div>
            @endif

            @if($title)
            <h4 class="card-title mb-1">{!! $title !!}</h4>
            @endif

            <div class="metric-header">{!! $header !!}</div>
        </div>

        @if (! empty($subTitle))
        <span class="btn btn-sm bg-light shadow-0 p-0">
            {{ $subTitle }}
        </span>
        @endif

        @if(! empty($dropdown))
        <div class="dropdown chart-dropdown">
            <button class="btn btn-sm btn-light shadow-0 dropdown-toggle p-0 waves-effect" data-toggle="dropdown">
                {{ current($dropdown) }}
            </button>
            <div class="dropdown-menu dropdown-menu-right">
                @foreach($dropdown as $key => $value)
                <li class="dropdown-item"><a href="javascript:void(0)" class="select-option" data-option="{{ $key }}">{{ $value }}</a></li>
                @endforeach
            </div>
        </div>
        @endif

        @if(! empty($datepicker))
        <div class="col-md-9 datepicker">
            <div class="row">
                <div class="col-lg-5 pl-0">
                    <div class="input-group">
                        <span class="input-group-prepend">
                            <span class="input-group-text bg-white"><i class="feather icon-calendar"></i></span>
                        </span>
                        <input autocomplete="off" type="text" name="started" value="{{ $datepicker['start'] }}" class="form-control field_started" required="1" id="asdsss">
                    </div>
                </div>
                <div class="col-lg-5 pl-0">
                    <div class="input-group">
                        <span class="input-group-prepend">
                            <span class="input-group-text bg-white"><i class="feather icon-calendar"></i></span>
                        </span>
                        <input autocomplete="off" type="text" name="ended" value="{{ $datepicker['end'] }}" class="form-control field_ended" required="1" id="_35455a066a22a942">
                    </div>
                </div>
                <div class="col-lg-2 pl-0 pr-0">
                    <button class="btn btn-primary btn-outline-info" data-started="{{ $datepicker['start'] }}" data-ended="{{ $datepicker['end'] }}">
                        <span class="d-none d-sm-inline">查询</span>
                    </button>
                </div>
            </div>
        </div>
        @endif

    </div>

    <div class="metric-content">{!! $content !!}</div>
</div>