<?php

namespace App\Store\Controllers;

use App\Models\Merchant;
use App\Store\Metrics\Examples;
use App\Http\Controllers\Controller;
use Dcat\Admin\Admin;
use Dcat\Admin\Http\Controllers\Dashboard;
use Dcat\Admin\Layout\Column;
use Dcat\Admin\Layout\Content;
use Dcat\Admin\Layout\Row;
use Dcat\Admin\Widgets\Card;

class HomeController extends Controller
{
    public function index(Content $content)
    {
        return $content
            ->header('主页')
            ->description('数据总览')
            ->body(function (Row $row) {
                $day = date("d");

                $row->column(12, function (Column $column) {
                    $content = "上月数据统计";
                    $column->row(new Card('', $content));
                });
                $row->column(6, function (Column $column) {
                    $column->row(function (Row $row) {
                        $row->column(6, new Examples\LastProductOrders());
                        $row->column(6, new Examples\LastStockTotal());
                    });
                });
                $row->column(6, function (Column $column) {
                    $column->row(function (Row $row) {
                        $row->column(6, new Examples\LastPickupTotal());
                        $row->column(6, new Examples\LastWaitPickTotal());
                    });
                });


                $row->column(12, function (Column $column) {
                    $content = "本月数据统计";
                    $column->row(new Card('', $content));
                });

                $row->column(6, function (Column $column) {
                    $column->row(function (Row $row) {
                        $row->column(6, new Examples\ProductOrders());
                        $row->column(6, new Examples\StockTotal());
                    });
                });
                $row->column(6, function (Column $column) {
                    $column->row(function (Row $row) {
                        $row->column(6, new Examples\PickupTotal('已取货状态'));
                        $row->column(6, new Examples\WaitPickTotal('待取货状态'));
                    });
                });

                // $row->column(12, function (Column $column) {
                //     $store = Merchant::where(['id' => Admin::user()->id])->first();
                //     $total_revenue = $store->total_revenue > 1000 ? round(2, ($store->total_revenue / 1000)) . ' 千' : $store->total_revenue;
                //     $balance = $store->balance > 1000 ? round(2, ($store->balance / 1000)) . ' 千' : $store->balance;
                //     $freeze_balance = $store->freeze_balance > 1000 ? round(2, ($store->freeze_balance / 1000)) . ' 千' : $store->freeze_balance;
                //     $content = '<div style="height: 135px;display: flex;align-items: center;text-align: center;">
                //     <div style="flex: 1;display: flex;flex-direction: column;border-right: 1px solid #b9c3cd;">
                //     <h2 style="font-size: 25px;margin-top: 25px;">总收益</h2>
                //     <p style="color: orange;font-size: 45px;font-weight: bold;">100</p>
                //     </div>
                //     <div style="flex: 1;display: flex;flex-direction: column;border-right: 1px solid #b9c3cd;">
                //     <h2 style="font-size: 25px;margin-top: 25px;">余额(可提现)</h2><p style="color:#21b978;font-size: 45px;font-weight: bold;">80</p>
                //     </div>
                //     <div style="flex: 1;display: flex;flex-direction: column;">
                //     <h2 style="font-size: 25px;margin-top: 25px;">冻结金额(提现中)</h2><p style="color: red;font-size: 45px;font-weight: bold;">' . $freeze_balance . '</p>
                //     </div></div>';
                //     $column->row(new Card('', $content));
                // });

                $row->column(12, function (Column $column) {

                    //$column->row(new Examples\StoreOrderChats());
                });
            });
    }
}
