<?php

namespace App\Models;

use Dcat\Admin\Traits\HasDateTimeFormatter;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Model;

class Income extends Model
{
    use HasDateTimeFormatter;
    use SoftDeletes;
    protected $table = 'income';

    public const USER_TYPE = [
        1 => '会员',
        2 => '商户',
    ];

    public const STATUS = [
        0 => '待审核',
        1 => '审核通过',
        2 => '拒绝提现'
    ];
}
